/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.asciidocreport.plantuml;

import com.buschmais.jqassistant.core.report.api.ReportContext;
import com.buschmais.jqassistant.core.report.api.ReportException;
import com.buschmais.jqassistant.core.report.api.ReportPlugin;
import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.plugin.asciidocreport.plantuml.AbstractDiagramRenderer;
import com.buschmais.jqassistant.plugin.asciidocreport.plantuml.ImageRenderer;
import com.buschmais.jqassistant.plugin.asciidocreport.plantuml.RenderMode;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import net.sourceforge.plantuml.FileFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPlantUMLReportPlugin
implements ReportPlugin {
    private static final Logger log = LoggerFactory.getLogger(AbstractPlantUMLReportPlugin.class);
    private static final String PROPERTY_FILE_FORMAT = "plantuml.report.format";
    private static final String PROPERTY_RENDER_MODE = "plantuml.report.rendermode";
    private static final String DEFAULT_FILE_FORMAT = FileFormat.SVG.name();
    private final ImageRenderer imageRenderer = new ImageRenderer();
    private ReportContext reportContext;
    private File directory;
    private String fileFormat;
    private RenderMode renderMode;

    public void initialize() {
    }

    public void configure(ReportContext reportContext, Map<String, Object> properties) throws ReportException {
        this.reportContext = reportContext;
        this.directory = reportContext.getReportDirectory("plantuml");
        this.fileFormat = (String)properties.getOrDefault(PROPERTY_FILE_FORMAT, DEFAULT_FILE_FORMAT);
        String renderModeValue = properties.getOrDefault(PROPERTY_RENDER_MODE, null);
        this.renderMode = RenderMode.getRenderMode(renderModeValue);
    }

    public void setResult(Result<? extends ExecutableRule> result) throws ReportException {
        URL url;
        String diagram = this.getRenderer(this.renderMode).renderDiagram(result);
        File file = this.imageRenderer.renderDiagram(diagram, result.getRule(), this.directory, this.fileFormat);
        try {
            url = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new ReportException("Cannot convert file '" + file.getAbsolutePath() + "' to URL");
        }
        this.reportContext.addReport(this.getReportLabel(), result.getRule(), ReportContext.ReportType.IMAGE, url);
    }

    protected abstract AbstractDiagramRenderer getRenderer(RenderMode var1);

    protected abstract String getReportLabel();
}

