/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.asciidocreport.plantuml;

import com.buschmais.jqassistant.core.report.api.ReportException;
import com.buschmais.jqassistant.core.report.api.graph.model.Node;
import com.buschmais.jqassistant.core.report.api.graph.model.Relationship;
import com.buschmais.jqassistant.core.report.api.graph.model.SubGraph;
import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.plugin.asciidocreport.plantuml.RenderMode;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractDiagramRenderer {
    private final RenderMode renderMode;

    protected AbstractDiagramRenderer(RenderMode renderMode) {
        this.renderMode = renderMode;
    }

    public String renderDiagram(Result<? extends ExecutableRule> result) throws ReportException {
        StringBuilder plantumlBuilder = new StringBuilder();
        plantumlBuilder.append("@startuml").append('\n');
        plantumlBuilder.append("skinparam componentStyle uml2").append('\n');
        plantumlBuilder.append(this.renderMode.getPragma());
        this.render(result, plantumlBuilder);
        plantumlBuilder.append("@enduml").append('\n');
        return plantumlBuilder.toString();
    }

    protected abstract void render(Result<? extends ExecutableRule> var1, StringBuilder var2) throws ReportException;

    protected String indent(int level) {
        char[] indent = new char[level * 2];
        Arrays.fill(indent, ' ');
        return new String(indent);
    }

    protected String getNodeId(Node node) {
        String id = "n" + node.getId();
        return id.replaceAll("-", "_");
    }

    protected Map<Long, Relationship> getRelationships(SubGraph graph, Map<Long, Node> nodes) {
        LinkedHashMap<Long, Relationship> relationships = new LinkedHashMap<Long, Relationship>();
        for (Map.Entry entry : graph.getRelationships().entrySet()) {
            Relationship relationship = (Relationship)entry.getValue();
            if (!nodes.containsKey(relationship.getStartNode().getId()) || !nodes.containsKey(relationship.getEndNode().getId())) continue;
            relationships.put((Long)entry.getKey(), relationship);
        }
        for (SubGraph subgraph : graph.getSubGraphs().values()) {
            relationships.putAll(this.getRelationships(subgraph, nodes));
        }
        return relationships;
    }
}

