/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.asciidocreport.include;

import com.buschmais.jqassistant.core.rule.api.filter.RuleFilter;
import com.buschmais.jqassistant.plugin.asciidocreport.RuleResult;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.asciidoctor.ast.StructuralNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SummaryFilter {
    private static final Logger log = LoggerFactory.getLogger(SummaryFilter.class);
    private final Map<String, RuleResult> conceptResults;
    private final Map<String, RuleResult> constraintResults;
    private final Map<String, StructuralNode> ruleBlocks;
    private final RuleFilter ruleFilter;

    public SummaryFilter(Map<String, RuleResult> conceptResults, Map<String, RuleResult> constraintResults, Map<String, StructuralNode> ruleBlocks, RuleFilter ruleFilter) {
        this.conceptResults = conceptResults;
        this.constraintResults = constraintResults;
        this.ruleBlocks = ruleBlocks;
        this.ruleFilter = ruleFilter;
    }

    public Result apply(Map<String, Object> attributes) {
        if (attributes.isEmpty()) {
            return Result.builder().constraints(this.constraintResults.values()).concepts(this.conceptResults.values()).build();
        }
        List<RuleResult> constraints = this.include(attributes, "constraints", "importedConstraints", this.constraintResults);
        List<RuleResult> concepts = this.include(attributes, "concepts", "importedConcepts", this.conceptResults);
        if (concepts.isEmpty() && constraints.isEmpty()) {
            log.warn("No constraints/concepts found matching the given filters {}.", attributes);
        }
        return Result.builder().constraints(constraints).concepts(concepts).build();
    }

    private List<RuleResult> include(Map<String, Object> attributes, String rulesAttribute, String importedRulesAttribute, Map<String, RuleResult> results) {
        String rulesFilter = (String)attributes.get(rulesAttribute);
        String importedRulesFilter = (String)attributes.get(importedRulesAttribute);
        return this.filterRuleResults(results, rulesFilter, importedRulesFilter);
    }

    private List<RuleResult> filterRuleResults(Map<String, RuleResult> results, String rulesFilter, String importedRulesFilter) {
        HashSet ruleResults = new HashSet();
        Set rules = results.keySet().stream().filter(rule -> this.ruleBlocks.keySet().contains(rule)).collect(Collectors.toSet());
        ruleResults.addAll(this.ruleFilter.match(rules, rulesFilter));
        Set importedRules = results.keySet().stream().filter(rule -> !this.ruleBlocks.keySet().contains(rule)).collect(Collectors.toSet());
        ruleResults.addAll(this.ruleFilter.match(importedRules, importedRulesFilter));
        return results.entrySet().stream().filter(entry -> ruleResults.contains(entry.getKey())).map(entry -> (RuleResult)entry.getValue()).collect(Collectors.toList());
    }

    static class Result {
        private Collection<RuleResult> constraints;
        private Collection<RuleResult> concepts;

        Result(Collection<RuleResult> constraints, Collection<RuleResult> concepts) {
            this.constraints = constraints;
            this.concepts = concepts;
        }

        public static ResultBuilder builder() {
            return new ResultBuilder();
        }

        public Collection<RuleResult> getConstraints() {
            return this.constraints;
        }

        public Collection<RuleResult> getConcepts() {
            return this.concepts;
        }

        public String toString() {
            return "SummaryFilter.Result(constraints=" + this.getConstraints() + ", concepts=" + this.getConcepts() + ")";
        }

        public static class ResultBuilder {
            private Collection<RuleResult> constraints;
            private Collection<RuleResult> concepts;

            ResultBuilder() {
            }

            public ResultBuilder constraints(Collection<RuleResult> constraints) {
                this.constraints = constraints;
                return this;
            }

            public ResultBuilder concepts(Collection<RuleResult> concepts) {
                this.concepts = concepts;
                return this;
            }

            public Result build() {
                return new Result(this.constraints, this.concepts);
            }

            public String toString() {
                return "SummaryFilter.Result.ResultBuilder(constraints=" + this.constraints + ", concepts=" + this.concepts + ")";
            }
        }
    }
}

