/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.asciidocreport;

import com.buschmais.jqassistant.core.rule.api.filter.RuleFilter;
import com.buschmais.jqassistant.core.shared.asciidoc.DocumentParser;
import com.buschmais.jqassistant.plugin.asciidocreport.RuleResult;
import com.buschmais.jqassistant.plugin.asciidocreport.include.ImportedRulesIncludeStrategy;
import com.buschmais.jqassistant.plugin.asciidocreport.include.IncludeStrategy;
import com.buschmais.jqassistant.plugin.asciidocreport.include.RulesIncludeStrategy;
import com.buschmais.jqassistant.plugin.asciidocreport.include.SummaryFilter;
import com.buschmais.jqassistant.plugin.asciidocreport.include.SummaryIncludeStrategy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.extension.PreprocessorReader;

public class IncludeProcessor
extends org.asciidoctor.extension.IncludeProcessor {
    public static final String PREFIX = "jQA:";
    private Map<String, IncludeStrategy> strategies;

    public IncludeProcessor(DocumentParser documentParser, Document document, Map<String, RuleResult> conceptResults, Map<String, RuleResult> constraintResults) {
        DocumentParser.Result result = documentParser.parse(document);
        HashMap<String, StructuralNode> ruleBlocks = new HashMap<String, StructuralNode>();
        ruleBlocks.putAll(result.getConcepts());
        ruleBlocks.putAll(result.getConstraints());
        HashSet includedRules = new HashSet();
        RuleFilter ruleFilter = RuleFilter.getInstance();
        SummaryFilter summaryFilter = new SummaryFilter(conceptResults, constraintResults, ruleBlocks, ruleFilter);
        this.strategies = Arrays.asList(new SummaryIncludeStrategy(conceptResults, constraintResults, summaryFilter), new RulesIncludeStrategy(conceptResults, constraintResults, ruleFilter, ruleBlocks, includedRules), new ImportedRulesIncludeStrategy(conceptResults, constraintResults, ruleBlocks, includedRules)).stream().collect(Collectors.toMap(strategy -> strategy.getName(), strategy -> strategy));
    }

    public boolean handles(String target) {
        return target.startsWith(PREFIX);
    }

    public void process(Document document, PreprocessorReader reader, String target, Map<String, Object> attributes) {
        String include = target.substring(PREFIX.length());
        IncludeStrategy strategy = this.strategies.get(include);
        StringBuilder builder = new StringBuilder();
        if (strategy == null) {
            throw new IllegalArgumentException("jQA include not supported: " + target);
        }
        strategy.process(attributes, builder);
        reader.push_include(builder.toString(), target, include, 1, attributes);
    }
}

