/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.asciidocreport;

import com.buschmais.jqassistant.core.report.api.ReportContext;
import com.buschmais.jqassistant.core.report.api.ReportException;
import com.buschmais.jqassistant.core.report.api.ReportHelper;
import com.buschmais.jqassistant.core.report.api.ReportPlugin;
import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.rule.api.model.Concept;
import com.buschmais.jqassistant.core.rule.api.model.Constraint;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.core.rule.api.model.Group;
import com.buschmais.jqassistant.core.rule.api.model.Rule;
import com.buschmais.jqassistant.core.rule.api.source.RuleSource;
import com.buschmais.jqassistant.core.shared.annotation.ToBeRemovedInVersion;
import com.buschmais.jqassistant.core.shared.asciidoc.AsciidoctorFactory;
import com.buschmais.jqassistant.core.shared.asciidoc.DocumentParser;
import com.buschmais.jqassistant.plugin.asciidocreport.IncludeProcessor;
import com.buschmais.jqassistant.plugin.asciidocreport.InlineMacroProcessor;
import com.buschmais.jqassistant.plugin.asciidocreport.PluginIncludeProcessor;
import com.buschmais.jqassistant.plugin.asciidocreport.RulePostProcessor;
import com.buschmais.jqassistant.plugin.asciidocreport.RuleResult;
import com.buschmais.jqassistant.plugin.asciidocreport.RuleSourceMatcher;
import com.buschmais.jqassistant.plugin.asciidocreport.TreePreprocessor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Attributes;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.asciidoctor.ast.Document;
import org.asciidoctor.extension.JavaExtensionRegistry;
import org.asciidoctor.extension.Postprocessor;
import org.asciidoctor.extension.Treeprocessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ReportPlugin.Default
public class AsciidocReportPlugin
implements ReportPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsciidocReportPlugin.class);
    private static final String PROPERTY_DIRECTORY = "asciidoc.report.directory";
    @ToBeRemovedInVersion(major=1, minor=12)
    private static final String PROPERTY_RULE_DIRECTORY = "asciidoc.report.rule.directory";
    private static final String PROPERTY_FILE_INCLUDE = "asciidoc.report.file.include";
    private static final String PROPERTY_FILE_EXCLUDE = "asciidoc.report.file.exclude";
    private static final String DEFAULT_REPORT_DIRECTORY = "asciidoc";
    private static final String BACKEND_HTML5 = "html5";
    private static final String CODERAY = "coderay";
    private final DocumentParser documentParser = new DocumentParser();
    private ReportContext reportContext;
    private File reportDirectory;
    private RuleSourceMatcher ruleSourceMatcher;
    private Set<RuleSource> ruleSources;
    private Map<String, RuleResult> conceptResults;
    private Map<String, RuleResult> constraintResults;

    public void configure(ReportContext reportContext, Map<String, Object> properties) {
        this.reportContext = reportContext;
        File defaultReportDirectory = reportContext.getReportDirectory(DEFAULT_REPORT_DIRECTORY);
        this.reportDirectory = this.getFile(PROPERTY_DIRECTORY, defaultReportDirectory, properties).getAbsoluteFile();
        if (this.reportDirectory.mkdirs()) {
            LOGGER.info("Created directory '" + this.reportDirectory.getAbsolutePath() + "'.");
        }
        File ruleDirectory = this.getFile(PROPERTY_RULE_DIRECTORY, null, properties);
        String fileInclude = (String)properties.get(PROPERTY_FILE_INCLUDE);
        String fileExclude = (String)properties.get(PROPERTY_FILE_EXCLUDE);
        this.ruleSourceMatcher = new RuleSourceMatcher(ruleDirectory, fileInclude, fileExclude);
    }

    private File getFile(String property, File defaultValue, Map<String, Object> properties) {
        String directoryName = (String)properties.get(property);
        return directoryName != null ? new File(directoryName) : defaultValue;
    }

    public void begin() {
        this.ruleSources = new HashSet<RuleSource>();
        this.conceptResults = new HashMap<String, RuleResult>();
        this.constraintResults = new HashMap<String, RuleResult>();
    }

    public void end() throws ReportException {
        List<RuleSource> filteredRuleSources = this.ruleSourceMatcher.match(this.ruleSources);
        if (!filteredRuleSources.isEmpty()) {
            LOGGER.info("Calling for the Asciidoctor...");
            Asciidoctor asciidoctor = AsciidoctorFactory.getAsciidoctor();
            LOGGER.info("Writing to report directory " + this.reportDirectory.getAbsolutePath());
            for (RuleSource ruleSource : filteredRuleSources) {
                OptionsBuilder optionsBuilder = Options.builder().mkDirs(true).toDir(this.reportDirectory).backend(BACKEND_HTML5).safe(SafeMode.UNSAFE).attributes(Attributes.builder().experimental(true).sourceHighlighter(CODERAY).icons("font").build());
                ruleSource.getDirectory().ifPresent(baseDir -> optionsBuilder.baseDir(baseDir));
                String outputFileName = this.getOutputFileName(ruleSource);
                optionsBuilder.toFile(new File(outputFileName));
                Options options = optionsBuilder.build();
                LOGGER.info("-> {}", (Object)ruleSource);
                String content = this.readContent(ruleSource);
                Document document = asciidoctor.load(content, options);
                JavaExtensionRegistry extensionRegistry = asciidoctor.javaExtensionRegistry();
                IncludeProcessor includeProcessor = new IncludeProcessor(this.documentParser, document, this.conceptResults, this.constraintResults);
                extensionRegistry.includeProcessor((org.asciidoctor.extension.IncludeProcessor)includeProcessor);
                extensionRegistry.includeProcessor((org.asciidoctor.extension.IncludeProcessor)new PluginIncludeProcessor(ruleSource.getRelativePath()));
                extensionRegistry.inlineMacro((org.asciidoctor.extension.InlineMacroProcessor)new InlineMacroProcessor(this.documentParser));
                extensionRegistry.treeprocessor((Treeprocessor)new TreePreprocessor(this.documentParser, this.conceptResults, this.constraintResults, new File(this.reportDirectory, outputFileName).getParentFile(), this.reportContext));
                extensionRegistry.postprocessor((Postprocessor)new RulePostProcessor(this.conceptResults, this.constraintResults));
                asciidoctor.convert(content, options);
                asciidoctor.unregisterAllExtensions();
            }
            LOGGER.info("The Asciidoctor finished his work successfully.");
        }
    }

    private String readContent(RuleSource ruleSource) throws ReportException {
        String content;
        try (InputStream inputStream = ruleSource.getInputStream();){
            content = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new ReportException("Cannot read rule source " + ruleSource);
        }
        return content;
    }

    private String getOutputFileName(RuleSource ruleSource) {
        String relativePath = ruleSource.getRelativePath();
        return relativePath.substring(0, relativePath.lastIndexOf(46)) + ".html";
    }

    public void beginGroup(Group group) {
        this.addRuleSource((Rule)group);
    }

    public void beginConcept(Concept concept) {
        this.addRuleSource((Rule)concept);
    }

    public void beginConstraint(Constraint constraint) {
        this.addRuleSource((Rule)constraint);
    }

    private void addRuleSource(Rule rule) {
        this.ruleSources.add(rule.getSource());
    }

    public void setResult(Result<? extends ExecutableRule> result) {
        ExecutableRule rule = result.getRule();
        if (rule instanceof Concept) {
            this.conceptResults.put(rule.getId(), this.getRuleResult(result));
        } else if (rule instanceof Constraint) {
            this.constraintResults.put(rule.getId(), this.getRuleResult(result));
        }
    }

    private RuleResult getRuleResult(Result<? extends ExecutableRule> result) {
        RuleResult.RuleResultBuilder ruleResultBuilder = RuleResult.builder();
        List columnNames = result.getColumnNames();
        ruleResultBuilder.rule(result.getRule()).effectiveSeverity(result.getSeverity()).status(result.getStatus()).columnNames(columnNames);
        for (Map row : result.getRows()) {
            LinkedHashMap<String, List<String>> resultRow = new LinkedHashMap<String, List<String>>();
            for (Map.Entry rowEntry : row.entrySet()) {
                Object value = rowEntry.getValue();
                ArrayList<String> values = new ArrayList<String>();
                if (value instanceof Iterable) {
                    for (Object o : (Iterable)value) {
                        values.add(ReportHelper.getLabel(o));
                    }
                } else {
                    values.add(ReportHelper.getLabel(value));
                }
                resultRow.put((String)rowEntry.getKey(), (List<String>)values);
            }
            ruleResultBuilder.row(resultRow);
        }
        return ruleResultBuilder.build();
    }
}

