/*
 * Decompiled with CFR 0.152.
 */
package com.bitmovin.api.resource.encoding;

import com.bitmovin.api.RestClient;
import com.bitmovin.api.encoding.encodings.Encoding;
import com.bitmovin.api.encoding.encodings.drms.AesEncryptionDrm;
import com.bitmovin.api.encoding.encodings.drms.CencDrm;
import com.bitmovin.api.encoding.encodings.drms.ClearKeyDrm;
import com.bitmovin.api.encoding.encodings.drms.FairPlayDrm;
import com.bitmovin.api.encoding.encodings.drms.MarlinDrm;
import com.bitmovin.api.encoding.encodings.drms.PlayReadyDrm;
import com.bitmovin.api.encoding.encodings.drms.PrimeTimeDrm;
import com.bitmovin.api.encoding.encodings.drms.TypeDrm;
import com.bitmovin.api.encoding.encodings.drms.WidevineDrm;
import com.bitmovin.api.encoding.encodings.muxing.FMP4Muxing;
import com.bitmovin.api.encoding.encodings.muxing.MP4Muxing;
import com.bitmovin.api.encoding.encodings.muxing.TSMuxing;
import com.bitmovin.api.exceptions.BitmovinApiException;
import com.bitmovin.api.http.RestException;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;

public class EncodingDrmResource {
    private Map<String, String> headers;

    public EncodingDrmResource(Map<String, String> headers) {
        this.headers = headers;
    }

    public WidevineDrm getWidevineDrm(Encoding encoding, FMP4Muxing muxing, String drmId) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        String newUrl = "encoding/encodings/{encoding_id}/muxings/fmp4/{muxing_id}/drm/widevine".replace("{encoding_id}", encoding.getId());
        newUrl = newUrl.replace("{muxing_id}", muxing.getId());
        newUrl = newUrl + "/" + drmId;
        return RestClient.get(newUrl, this.headers, WidevineDrm.class);
    }

    public PlayReadyDrm getPlayReadyDrm(Encoding encoding, FMP4Muxing muxing, String drmId) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        String newUrl = "encoding/encodings/{encoding_id}/muxings/fmp4/{muxing_id}/drm/playready".replace("{encoding_id}", encoding.getId());
        newUrl = newUrl.replace("{muxing_id}", muxing.getId());
        newUrl = newUrl + "/" + drmId;
        return RestClient.get(newUrl, this.headers, PlayReadyDrm.class);
    }

    public ClearKeyDrm getClearKeyDrm(Encoding encoding, FMP4Muxing muxing, String drmId) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        String newUrl = "encoding/encodings/{encoding_id}/muxings/fmp4/{muxing_id}/drm/clearkey".replace("{encoding_id}", encoding.getId());
        newUrl = newUrl.replace("{muxing_id}", muxing.getId());
        newUrl = newUrl + "/" + drmId;
        return RestClient.get(newUrl, this.headers, ClearKeyDrm.class);
    }

    public AesEncryptionDrm getAesEncryptionDrm(Encoding encoding, TSMuxing muxing, String drmId) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        String newUrl = "encoding/encodings/{encoding_id}/muxings/ts/{muxing_id}/drm/aes".replace("{encoding_id}", encoding.getId());
        newUrl = newUrl.replace("{muxing_id}", muxing.getId());
        newUrl = newUrl + "/" + drmId;
        return RestClient.get(newUrl, this.headers, AesEncryptionDrm.class);
    }

    public CencDrm getCencDrm(Encoding encoding, FMP4Muxing muxing, String drmId) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        String newUrl = "encoding/encodings/{encoding_id}/muxings/fmp4/{muxing_id}/drm/cenc".replace("{encoding_id}", encoding.getId());
        newUrl = newUrl.replace("{muxing_id}", muxing.getId());
        newUrl = newUrl + "/" + drmId;
        return RestClient.get(newUrl, this.headers, CencDrm.class);
    }

    public FairPlayDrm getFmp4FairPlayDrm(Encoding encoding, FMP4Muxing muxing, String drmId) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        String newUrl = "encoding/encodings/{encoding_id}/muxings/fmp4/{muxing_id}/drm/fairplay".replace("{encoding_id}", encoding.getId());
        newUrl = newUrl.replace("{muxing_id}", muxing.getId());
        newUrl = newUrl + "/" + drmId;
        return RestClient.get(newUrl, this.headers, FairPlayDrm.class);
    }

    public FairPlayDrm getTsFairPlayDrm(Encoding encoding, TSMuxing muxing, String drmId) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        String newUrl = "encoding/encodings/{encoding_id}/muxings/ts/{muxing_id}/drm/fairplay".replace("{encoding_id}", encoding.getId());
        newUrl = newUrl.replace("{muxing_id}", muxing.getId());
        newUrl = newUrl + "/" + drmId;
        return RestClient.get(newUrl, this.headers, FairPlayDrm.class);
    }

    public MarlinDrm getMarlinDrm(Encoding encoding, FMP4Muxing muxing, String drmId) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        String newUrl = "encoding/encodings/{encoding_id}/muxings/fmp4/{muxing_id}/drm/marlin".replace("{encoding_id}", encoding.getId());
        newUrl = newUrl.replace("{muxing_id}", muxing.getId());
        newUrl = newUrl + "/" + drmId;
        return RestClient.get(newUrl, this.headers, MarlinDrm.class);
    }

    public PrimeTimeDrm getPrimeTimeDrm(Encoding encoding, FMP4Muxing muxing, String drmId) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        String newUrl = "encoding/encodings/{encoding_id}/muxings/fmp4/{muxing_id}/drm/primetime".replace("{encoding_id}", encoding.getId());
        newUrl = newUrl.replace("{muxing_id}", muxing.getId());
        newUrl = newUrl + "/" + drmId;
        return RestClient.get(newUrl, this.headers, PrimeTimeDrm.class);
    }

    public List<TypeDrm> listFmp4Drms(Encoding encoding, FMP4Muxing muxing) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        String newUrl = "encoding/encodings/{encoding_id}/muxings/fmp4/{muxing_id}/drm".replace("{encoding_id}", encoding.getId());
        newUrl = newUrl.replace("{muxing_id}", muxing.getId());
        return RestClient.getItems(newUrl, this.headers, TypeDrm.class);
    }

    public List<TypeDrm> listTsDrms(Encoding encoding, TSMuxing muxing) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        String newUrl = "encoding/encodings/{encoding_id}/muxings/ts/{muxing_id}/drm".replace("{encoding_id}", encoding.getId());
        newUrl = newUrl.replace("{muxing_id}", muxing.getId());
        return RestClient.getItems(newUrl, this.headers, TypeDrm.class);
    }

    public List<TypeDrm> listMp4Drms(Encoding encoding, MP4Muxing muxing) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        String newUrl = "encoding/encodings/{encoding_id}/muxings/mp4/{muxing_id}/drm".replace("{encoding_id}", encoding.getId());
        newUrl = newUrl.replace("{muxing_id}", muxing.getId());
        return RestClient.getItems(newUrl, this.headers, TypeDrm.class);
    }
}

