/*
 * Decompiled with CFR 0.152.
 */
package com.bitmovin.api.http.utils;

import com.bitmovin.api.http.utils.RequestLogger;
import com.mashape.unirest.http.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseLogger {
    private static final Logger logger = LoggerFactory.getLogger(RequestLogger.class);

    public static void logRawResponse(HttpResponse<String> response) {
        String responseLog = "\nResponse:\n--------------------------------------------------------------------\nSTATUS: " + response.getStatus() + " - " + response.getStatusText() + "\nHEADERS: " + response.getHeaders() + "\n";
        try {
            String rawBody = IOUtils.toString((InputStream)response.getRawBody(), (Charset)StandardCharsets.UTF_8);
            responseLog = StringUtils.isNotBlank((CharSequence)rawBody) ? responseLog + "PAYLOAD: \n" + rawBody + "\n" : responseLog + "PAYLOAD: <EMPTY>\n";
            responseLog = responseLog + "--------------------------------------------------------------------\n";
            logger.info(responseLog);
        }
        catch (IOException e) {
            responseLog = responseLog + "PAYLOAD: <NOT PARSABLE>\n--------------------------------------------------------------------\n";
            logger.info(responseLog);
        }
    }
}

