/*
 * Decompiled with CFR 0.152.
 */
package com.bitmovin.api.http.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestLogger {
    private static final Logger logger = LoggerFactory.getLogger(RequestLogger.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static void logRequest(String method, String uri, Map<String, String> headers) {
        RequestLogger.logRequest(method, uri, null, headers);
    }

    public static void logRequest(String method, String uri, Object payload, Map<String, String> headers) {
        String request = "\nRequest:\n--------------------------------------------------------------------\nHTTP Method: " + method + "\nREST URI: " + uri + "\nHEADERS: " + headers + "\n";
        if (payload != null) {
            try {
                request = request + "PAYLOAD: \n" + objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(payload) + "\n";
            }
            catch (JsonProcessingException e) {
                logger.error("Error serializing payload for logging!", (Throwable)e);
            }
        }
        request = request + "--------------------------------------------------------------------\n";
        logger.info(request);
    }
}

