/*
 * Decompiled with CFR 0.152.
 */
package com.bitmovin.api.container;

import com.bitmovin.api.encoding.statistics.DaillySummaryEncodingStatistics;
import com.bitmovin.api.encoding.statistics.EncodingStatistics;
import com.bitmovin.api.encoding.statistics.LiveEncodingStatistics;
import com.bitmovin.api.encoding.statistics.SummaryEncodingStatistics;
import com.bitmovin.api.encoding.statistics.SummaryVodEncodingStatistics;
import com.bitmovin.api.resource.EncodingStatisticsResource;
import com.bitmovin.api.resource.EncodingSummaryStatisticsResource;
import com.bitmovin.api.resource.LiveEncodingEventsResource;
import java.util.Map;

public class StatisticsContainer {
    public EncodingStatisticsResource encodingStatistics;
    public EncodingStatisticsResource liveEncodingStatistics;
    public LiveEncodingEventsResource liveEncodingEvents;
    public EncodingSummaryStatisticsResource<DaillySummaryEncodingStatistics> dailySummary;
    public EncodingSummaryStatisticsResource<SummaryVodEncodingStatistics> vodSummary;
    public EncodingSummaryStatisticsResource<SummaryEncodingStatistics> liveSummary;
    private Map<String, String> headers;

    public StatisticsContainer(Map<String, String> headers) {
        this.headers = headers;
        this.encodingStatistics = new EncodingStatisticsResource<EncodingStatistics>(headers, "encoding/statistics/encodings/{encoding_id}", EncodingStatistics.class);
        this.liveEncodingStatistics = new EncodingStatisticsResource<LiveEncodingStatistics>(headers, "encoding/statistics/encodings/{encoding_id}/live-statistics", LiveEncodingStatistics.class);
        this.liveEncodingEvents = new LiveEncodingEventsResource(headers, "encoding/statistics/encodings/{encoding_id}/live-statistics/events");
        this.dailySummary = new EncodingSummaryStatisticsResource<DaillySummaryEncodingStatistics>(headers, "encoding/statistics/daily", DaillySummaryEncodingStatistics.class);
        this.vodSummary = new EncodingSummaryStatisticsResource<SummaryVodEncodingStatistics>(headers, "encoding/statistics/encodings/vod", SummaryVodEncodingStatistics.class);
        this.liveSummary = new EncodingSummaryStatisticsResource<SummaryEncodingStatistics>(headers, "encoding/statistics/encodings/live", SummaryEncodingStatistics.class);
    }
}

