/*
 * Decompiled with CFR 0.152.
 */
package com.bitmovin.api.container;

import com.bitmovin.api.RestClient;
import com.bitmovin.api.encoding.outputs.AkamaiNetStorageOutput;
import com.bitmovin.api.encoding.outputs.AzureOutput;
import com.bitmovin.api.encoding.outputs.BitmovinGcsOutput;
import com.bitmovin.api.encoding.outputs.BitmovinS3Output;
import com.bitmovin.api.encoding.outputs.FtpOutput;
import com.bitmovin.api.encoding.outputs.GcsOutput;
import com.bitmovin.api.encoding.outputs.GenericS3Output;
import com.bitmovin.api.encoding.outputs.LocalOutput;
import com.bitmovin.api.encoding.outputs.Output;
import com.bitmovin.api.encoding.outputs.OutputType;
import com.bitmovin.api.encoding.outputs.S3Output;
import com.bitmovin.api.encoding.outputs.S3RoleBasedOutput;
import com.bitmovin.api.encoding.outputs.SftpOutput;
import com.bitmovin.api.exceptions.BitmovinApiException;
import com.bitmovin.api.helper.Tuple;
import com.bitmovin.api.http.RestException;
import com.bitmovin.api.resource.OutputResource;
import com.bitmovin.api.rest.ResponseEnvelope;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.json.JSONObject;

public class OutputContainer {
    public OutputResource<AkamaiNetStorageOutput> akamaiNetStorage;
    public OutputResource<AzureOutput> azure;
    public OutputResource<BitmovinGcsOutput> bitmovinGcsOutput;
    public OutputResource<BitmovinS3Output> bitmovinS3Output;
    public OutputResource<FtpOutput> ftp;
    public OutputResource<GcsOutput> gcs;
    public OutputResource<LocalOutput> local;
    public OutputResource<S3Output> s3;
    public OutputResource<SftpOutput> sftp;
    public OutputResource<GenericS3Output> genericS3;
    public OutputResource<S3RoleBasedOutput> s3RoleBased;
    public OutputResource<Output> all;
    private Map<String, String> headers;

    public OutputContainer(Map<String, String> headers) {
        this.headers = headers;
        this.akamaiNetStorage = new OutputResource<AkamaiNetStorageOutput>(headers, "encoding/outputs/akamai-netstorage", AkamaiNetStorageOutput.class);
        this.azure = new OutputResource<AzureOutput>(headers, "encoding/outputs/azure", AzureOutput.class);
        this.bitmovinGcsOutput = new OutputResource<BitmovinGcsOutput>(headers, "encoding/outputs/bitmovingcs", BitmovinGcsOutput.class);
        this.bitmovinS3Output = new OutputResource<BitmovinS3Output>(headers, "encoding/outputs/bitmovins3", BitmovinS3Output.class);
        this.ftp = new OutputResource<FtpOutput>(headers, "encoding/outputs/ftp", FtpOutput.class);
        this.gcs = new OutputResource<GcsOutput>(headers, "encoding/outputs/gcs", GcsOutput.class);
        this.local = new OutputResource<LocalOutput>(headers, "encoding/outputs/local", LocalOutput.class);
        this.s3 = new OutputResource<S3Output>(headers, "encoding/outputs/s3", S3Output.class);
        this.sftp = new OutputResource<SftpOutput>(headers, "encoding/outputs/sftp", SftpOutput.class);
        this.all = new OutputResource<Output>(headers, "encoding/outputs", Output.class);
        this.genericS3 = new OutputResource<GenericS3Output>(headers, "encoding/outputs/generic-s3", GenericS3Output.class);
        this.s3RoleBased = new OutputResource<S3RoleBasedOutput>(headers, "encoding/outputs/s3-role-based", S3RoleBasedOutput.class);
    }

    public OutputType getType(String outputId) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        ResponseEnvelope responseEnvelope = RestClient.getRaw("encoding/outputs/" + outputId + "/type", this.headers, ResponseEnvelope.class);
        JSONObject responseObject = RestClient.convertToJsonObject(responseEnvelope);
        return OutputType.valueOf(responseObject.getJSONObject("data").getJSONObject("result").getString("type"));
    }

    public Tuple<OutputType, Output> get(String outputId) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        ResponseEnvelope responseEnvelope = RestClient.getRaw("encoding/outputs/" + outputId + "/type", this.headers, ResponseEnvelope.class);
        JSONObject responseObject = RestClient.convertToJsonObject(responseEnvelope);
        OutputType outputType = OutputType.valueOf(responseObject.getJSONObject("data").getJSONObject("result").getString("type"));
        if (outputType == null) {
            return null;
        }
        switch (outputType) {
            case S3: {
                return new Tuple<OutputType, Output>(outputType, (Output)this.s3.get(outputId));
            }
            case GCS: {
                return new Tuple<OutputType, Output>(outputType, (Output)this.gcs.get(outputId));
            }
            case FTP: {
                return new Tuple<OutputType, Output>(outputType, (Output)this.ftp.get(outputId));
            }
            case SFTP: {
                return new Tuple<OutputType, Output>(outputType, (Output)this.sftp.get(outputId));
            }
            case LOCAL: {
                return new Tuple<OutputType, Output>(outputType, (Output)this.local.get(outputId));
            }
            case AKAMAI_NETSTORAGE: {
                return new Tuple<OutputType, Output>(outputType, (Output)this.akamaiNetStorage.get(outputId));
            }
            case AZURE: {
                return new Tuple<OutputType, Output>(outputType, (Output)this.azure.get(outputId));
            }
            case GENERIC_S3: {
                return new Tuple<OutputType, Output>(outputType, (Output)this.genericS3.get(outputId));
            }
            case BITMOVIN_GCS: {
                return new Tuple<OutputType, Output>(outputType, (Output)this.bitmovinGcsOutput.get(outputId));
            }
            case BITMOVIN_S3: {
                return new Tuple<OutputType, Output>(outputType, (Output)this.bitmovinS3Output.get(outputId));
            }
            case S3_ROLE_BASED: {
                return new Tuple<OutputType, Output>(outputType, (Output)this.s3RoleBased.get(outputId));
            }
        }
        return null;
    }
}

