/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.utils;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertUtils {
    public static void assertParameterNotNull(Object param, String paramName) {
        if (param == null) {
            throw new NullPointerException("ParameterIsNull " + paramName);
        }
    }

    public static void assertParameterInRange(long param, long lower, long upper) {
        if (!AssertUtils.checkParamRange(param, lower, true, upper, true)) {
            throw new IllegalArgumentException(String.format("%d not in valid range [%d, %d]", param, lower, upper));
        }
    }

    public static void assertStringNotNullOrEmpty(String param, String paramName) {
        AssertUtils.assertParameterNotNull(param, paramName);
        if (param.trim().length() == 0) {
            throw new IllegalArgumentException("ParameterStringIsEmpty " + paramName);
        }
    }

    public static void assertListNotNullOrEmpty(List<?> param, String paramName) {
        AssertUtils.assertParameterNotNull(param, paramName);
        if (param.size() == 0) {
            throw new IllegalArgumentException("ParameterListIsEmpty" + paramName);
        }
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static void assertTrue(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static boolean checkParamRange(long param, long from, boolean leftInclusive, long to, boolean rightInclusive) {
        if (leftInclusive && rightInclusive) {
            return from <= param && param <= to;
        }
        if (leftInclusive && !rightInclusive) {
            return from <= param && param < to;
        }
        if (!leftInclusive && !rightInclusive) {
            return from < param && param < to;
        }
        return from < param && param <= to;
    }

    public static void checkFileLength(Long maxLength, Long length) {
        if (length <= 0L) {
            throw new IllegalArgumentException("file length is illeagal:" + length);
        }
        if (length > maxLength) {
            throw new IllegalArgumentException("file length is larger:" + length + "than supported length :" + maxLength);
        }
    }

    public static void checkUrl(String url) {
        AssertUtils.assertStringNotNullOrEmpty(url, "url");
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            throw new IllegalArgumentException("Url must starts with http(s)://.");
        }
    }
}

