/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.service;

import com.alibaba.fastjson.TypeReference;
import com.bimface.sdk.bean.GeneralResponse;
import com.bimface.sdk.config.Endpoint;
import com.bimface.sdk.exception.BimfaceException;
import com.bimface.sdk.http.HttpHeaders;
import com.bimface.sdk.http.HttpUtils;
import com.bimface.sdk.http.ServiceClient;
import com.bimface.sdk.service.AbstractAccessTokenService;
import com.bimface.sdk.service.AccessTokenService;
import com.bimface.sdk.utils.AssertUtils;
import com.squareup.okhttp.Response;

public class ViewTokenService
extends AbstractAccessTokenService {
    private final String VIEW_TOKEN_URL = this.getApiHost() + "/view/token?viewId=%s";

    public ViewTokenService(ServiceClient serviceClient, Endpoint endpoint, AccessTokenService accessTokenService) {
        super(serviceClient, endpoint, accessTokenService);
    }

    public String grantViewToken(String viewId) throws BimfaceException {
        AssertUtils.assertStringNotNullOrEmpty(viewId, "viewId");
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(this.getAccessToken());
        Response response = this.getServiceClient().get(String.format(this.VIEW_TOKEN_URL, viewId), headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<String>>(){});
    }
}

