/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.service;

import com.alibaba.fastjson.TypeReference;
import com.bimface.sdk.bean.GeneralResponse;
import com.bimface.sdk.bean.request.FileUploadRequest;
import com.bimface.sdk.bean.response.FileBean;
import com.bimface.sdk.bean.response.SupportFileBean;
import com.bimface.sdk.config.Endpoint;
import com.bimface.sdk.exception.BimfaceException;
import com.bimface.sdk.http.HttpHeaders;
import com.bimface.sdk.http.HttpUtils;
import com.bimface.sdk.http.ServiceClient;
import com.bimface.sdk.service.AbstractAccessTokenService;
import com.bimface.sdk.service.AccessTokenService;
import com.bimface.sdk.service.SupportFileService;
import com.bimface.sdk.utils.AssertUtils;
import com.bimface.sdk.utils.FileNameUtils;
import com.squareup.okhttp.Response;

public class UploadService
extends AbstractAccessTokenService {
    private final String UPLOAD_URL = this.getFileHost() + "/upload?name=%s";
    private final String UPLOAD_BY_URL_URL = this.getFileHost() + "/upload?name=%s&url=%s";
    private SupportFileService supportFileService;

    public UploadService(ServiceClient serviceClient, Endpoint endpoint, AccessTokenService accessTokenService) {
        super(serviceClient, endpoint, accessTokenService);
    }

    public FileBean upload(FileUploadRequest fileUploadRequest) throws BimfaceException {
        this.check(fileUploadRequest);
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(this.getAccessToken());
        Response response = null;
        String requestUrl = null;
        if (fileUploadRequest.isByUrl()) {
            requestUrl = String.format(this.UPLOAD_BY_URL_URL, fileUploadRequest.getName(), fileUploadRequest.getUrl());
            response = this.getServiceClient().put(requestUrl, headers);
        } else {
            requestUrl = String.format(this.UPLOAD_URL, fileUploadRequest.getName());
            headers.addHeader("Content-Length", fileUploadRequest.getContentLength().toString());
            response = this.getServiceClient().put(requestUrl, fileUploadRequest.getInputStream(), fileUploadRequest.getContentLength(), headers);
        }
        return HttpUtils.response(response, new TypeReference<GeneralResponse<FileBean>>(){});
    }

    private void check(FileUploadRequest fileUploadRequest) throws BimfaceException {
        AssertUtils.assertParameterNotNull(fileUploadRequest, "fileUploadRequest");
        FileNameUtils.checkFileName(fileUploadRequest.getName());
        if (fileUploadRequest.isByUrl()) {
            AssertUtils.checkUrl(fileUploadRequest.getUrl());
        } else {
            if (fileUploadRequest.getContentLength() == null || fileUploadRequest.getContentLength() < 0L) {
                throw new IllegalArgumentException("ContentLength is null.");
            }
            AssertUtils.assertParameterNotNull(fileUploadRequest.getInputStream(), "inputStream");
        }
        SupportFileBean supportFileBean = this.getSupportFileService().getSupport();
        String[] allSupportedType = supportFileBean.getTypes();
        FileNameUtils.checkFileType(allSupportedType, fileUploadRequest.getName());
        AssertUtils.checkFileLength(supportFileBean.getLength(), fileUploadRequest.getContentLength());
    }

    public void setSupportFileService(SupportFileService supportFileService) {
        this.supportFileService = supportFileService;
    }

    public SupportFileService getSupportFileService() {
        return this.supportFileService;
    }
}

