/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.service;

import com.alibaba.fastjson.TypeReference;
import com.bimface.sdk.bean.GeneralResponse;
import com.bimface.sdk.bean.response.ShareLinkBean;
import com.bimface.sdk.config.Endpoint;
import com.bimface.sdk.exception.BimfaceException;
import com.bimface.sdk.http.HttpHeaders;
import com.bimface.sdk.http.HttpUtils;
import com.bimface.sdk.http.ServiceClient;
import com.bimface.sdk.service.AbstractAccessTokenService;
import com.bimface.sdk.service.AccessTokenService;
import com.bimface.sdk.utils.AssertUtils;
import com.squareup.okhttp.Response;

public class ShareLinkService
extends AbstractAccessTokenService {
    private final String CREATE_SHARE_URL = this.getApiHost() + "/share?viewId=%s&activeHours=%s";
    private final String CREATE_SHARE_URL_FOREVER = this.getApiHost() + "/share?viewId=%s";
    private final String DELETE_SHARE_URL = this.getApiHost() + "/share?viewId=%s";

    public ShareLinkService(ServiceClient serviceClient, Endpoint endpoint, AccessTokenService accessTokenService) {
        super(serviceClient, endpoint, accessTokenService);
    }

    public ShareLinkBean create(String viewId, Integer activeHours) throws BimfaceException {
        AssertUtils.assertStringNotNullOrEmpty(viewId, "viewId");
        if (activeHours != null && activeHours <= 0) {
            throw new IllegalArgumentException("activeHours must not less than zero.");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(this.getAccessToken());
        Response response = this.getServiceClient().post(String.format(this.CREATE_SHARE_URL, viewId, activeHours), "", headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<ShareLinkBean>>(){});
    }

    public ShareLinkBean create(String viewId) throws BimfaceException {
        AssertUtils.assertStringNotNullOrEmpty(viewId, "viewId");
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(this.getAccessToken());
        Response response = this.getServiceClient().post(String.format(this.CREATE_SHARE_URL_FOREVER, viewId), "", headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<ShareLinkBean>>(){});
    }

    public String delete(String viewId) throws BimfaceException {
        AssertUtils.assertStringNotNullOrEmpty(viewId, "viewId");
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(this.getAccessToken());
        Response response = this.getServiceClient().delete(String.format(this.DELETE_SHARE_URL, viewId), headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<String>>(){});
    }
}

