/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.bean.request;

import com.bimface.sdk.constants.BimfaceConstants;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class FileUploadRequest {
    private String name;
    private Long contentLength;
    private InputStream inputStream;
    private String url;

    public FileUploadRequest() {
    }

    public FileUploadRequest(String name, String url) {
        this.name = name;
        this.url = url;
    }

    public FileUploadRequest(String name, Long contentLength, InputStream inputStream) {
        this.name = name;
        this.contentLength = contentLength;
        this.inputStream = inputStream;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            return;
        }
        try {
            this.name = URLEncoder.encode(name, BimfaceConstants.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(Long contentLength) {
        this.contentLength = contentLength;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        if (url == null) {
            return;
        }
        try {
            this.url = URLEncoder.encode(url, BimfaceConstants.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public boolean isByUrl() {
        return this.url != null && this.url.length() > 0;
    }
}

