/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk;

import com.bimface.sdk.bean.request.FileTransferRequest;
import com.bimface.sdk.bean.request.FileUploadRequest;
import com.bimface.sdk.bean.response.FileBean;
import com.bimface.sdk.bean.response.ShareLinkBean;
import com.bimface.sdk.bean.response.SupportFileBean;
import com.bimface.sdk.bean.response.TransferBean;
import com.bimface.sdk.config.Config;
import com.bimface.sdk.config.Endpoint;
import com.bimface.sdk.config.authorization.AccessTokenStorage;
import com.bimface.sdk.config.authorization.Credential;
import com.bimface.sdk.config.authorization.DefaultAccessTokenStorage;
import com.bimface.sdk.exception.BimfaceException;
import com.bimface.sdk.http.ServiceClient;
import com.bimface.sdk.service.AccessTokenService;
import com.bimface.sdk.service.ShareLinkService;
import com.bimface.sdk.service.SignatureService;
import com.bimface.sdk.service.SupportFileService;
import com.bimface.sdk.service.TransferService;
import com.bimface.sdk.service.UploadService;
import com.bimface.sdk.service.ViewTokenService;
import java.io.InputStream;

public class BimfaceClient {
    private Credential credential;
    private Endpoint endpoint;
    private ServiceClient serviceClient;
    private AccessTokenService accessTokenService;
    private SupportFileService supportFileService;
    private UploadService uploadService;
    private TransferService transferService;
    private ViewTokenService viewTokenService;
    private ShareLinkService shareLinkService;
    private SignatureService signatureService;

    public BimfaceClient(String appKey, String appSecret) {
        this(appKey, appSecret, null, null, null);
    }

    public BimfaceClient(String appKey, String appSecret, Config config) {
        this(appKey, appSecret, null, config, null);
    }

    public BimfaceClient(String appKey, String appSecret, Endpoint endpoint, Config config) {
        this(appKey, appSecret, endpoint, config, null);
    }

    public BimfaceClient(String appKey, String appSecret, Endpoint endpoint, Config config, AccessTokenStorage accessTokenStorage) {
        this.credential = new Credential(appKey, appSecret);
        this.endpoint = endpoint == null ? new Endpoint() : endpoint;
        this.serviceClient = config == null ? new ServiceClient(new Config()) : new ServiceClient(config);
        AccessTokenStorage usedAccessTokenStorage = null;
        usedAccessTokenStorage = accessTokenStorage == null ? new DefaultAccessTokenStorage() : accessTokenStorage;
        this.accessTokenService = new AccessTokenService(this.serviceClient, this.endpoint, this.credential, usedAccessTokenStorage);
        this.supportFileService = new SupportFileService(this.serviceClient, this.endpoint, this.accessTokenService);
        this.uploadService = new UploadService(this.serviceClient, this.endpoint, this.accessTokenService);
        this.uploadService.setSupportFileService(this.supportFileService);
        this.transferService = new TransferService(this.serviceClient, this.endpoint, this.accessTokenService);
        this.viewTokenService = new ViewTokenService(this.serviceClient, this.endpoint, this.accessTokenService);
        this.shareLinkService = new ShareLinkService(this.serviceClient, this.endpoint, this.accessTokenService);
        this.signatureService = new SignatureService(this.credential);
    }

    public SupportFileBean getSupport() throws BimfaceException {
        return this.supportFileService.getSupport();
    }

    public FileBean upload(FileUploadRequest fileUploadRequest) throws BimfaceException {
        return this.uploadService.upload(fileUploadRequest);
    }

    public FileBean upload(String name, Long contentLength, InputStream inputStream) throws BimfaceException {
        return this.uploadService.upload(new FileUploadRequest(name, contentLength, inputStream));
    }

    public FileBean upload(String name, String url) throws BimfaceException {
        return this.uploadService.upload(new FileUploadRequest(name, url));
    }

    public TransferBean transfer(FileTransferRequest fileTransferRequest) throws BimfaceException {
        return this.transferService.transfer(fileTransferRequest);
    }

    public TransferBean transfer(Long fileId) throws BimfaceException {
        return this.transferService.transfer(new FileTransferRequest(fileId));
    }

    public TransferBean transfer(Long fileId, String callback) throws BimfaceException {
        return this.transferService.transfer(new FileTransferRequest(fileId, callback));
    }

    public TransferBean getTransfer(String viewId) throws BimfaceException {
        return this.transferService.getTransfer(viewId);
    }

    public String getViewToken(String viewId) throws BimfaceException {
        return this.viewTokenService.grantViewToken(viewId);
    }

    public ShareLinkBean createShareLink(String viewId, Integer activeHours) throws BimfaceException {
        return this.shareLinkService.create(viewId, activeHours);
    }

    public ShareLinkBean createShareLink(String viewId) throws BimfaceException {
        return this.shareLinkService.create(viewId);
    }

    public void deleteShareLink(String viewId) throws BimfaceException {
        this.shareLinkService.delete(viewId);
    }

    public boolean validateSignature(String signature, String viewId, String status, String nonce) throws BimfaceException {
        return this.signatureService.validate(signature, viewId, status, nonce);
    }

    public Credential getCredential() {
        return this.credential;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public ServiceClient getServiceClient() {
        return this.serviceClient;
    }

    public AccessTokenService getAccessTokenService() {
        return this.accessTokenService;
    }

    public SupportFileService getSupportFileService() {
        return this.supportFileService;
    }

    public UploadService getUploadService() {
        return this.uploadService;
    }

    public TransferService getTransferService() {
        return this.transferService;
    }

    public ViewTokenService getViewTokenService() {
        return this.viewTokenService;
    }

    public ShareLinkService getShareLinkService() {
        return this.shareLinkService;
    }

    public SignatureService getSignatureService() {
        return this.signatureService;
    }
}

