/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.pay.server.util;

public final class Base64Util {
    private static final char[] BASE_64_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '$', '_'};
    private static final byte[] BASE_64_CHARS_LOOKUP = new byte[128];

    private Base64Util() {
    }

    public static byte[] fromBase64(String data) {
        if (data == null) {
            return null;
        }
        int len = data.length();
        assert (len % 4 == 0);
        if (len == 0) {
            return new byte[0];
        }
        int olen = 3 * (len / 4);
        if (data.charAt(len - 2) == '=') {
            --olen;
        }
        if (data.charAt(len - 1) == '=') {
            --olen;
        }
        byte[] bytes = new byte[olen];
        int iidx = 0;
        int oidx = 0;
        while (iidx < len) {
            byte c0 = BASE_64_CHARS_LOOKUP[data.charAt(iidx++) & 0xFF];
            byte c1 = BASE_64_CHARS_LOOKUP[data.charAt(iidx++) & 0xFF];
            byte c2 = BASE_64_CHARS_LOOKUP[data.charAt(iidx++) & 0xFF];
            byte c3 = BASE_64_CHARS_LOOKUP[data.charAt(iidx++) & 0xFF];
            int c24 = c0 << 18 | c1 << 12 | c2 << 6 | c3;
            bytes[oidx++] = (byte)(c24 >> 16);
            if (oidx == olen) break;
            bytes[oidx++] = (byte)(c24 >> 8);
            if (oidx == olen) break;
            bytes[oidx++] = (byte)c24;
        }
        return bytes;
    }

    public static String toBase64(byte[] data) {
        if (data == null) {
            return null;
        }
        int len = data.length;
        if (len == 0) {
            return "";
        }
        int olen = 4 * ((len + 2) / 3);
        char[] chars = new char[olen];
        int iidx = 0;
        int oidx = 0;
        for (int charsLeft = len; charsLeft > 0; charsLeft -= 3) {
            int b0 = data[iidx++] & 0xFF;
            int b1 = charsLeft > 1 ? data[iidx++] & 0xFF : 0;
            int b2 = charsLeft > 2 ? data[iidx++] & 0xFF : 0;
            int b24 = b0 << 16 | b1 << 8 | b2;
            int c0 = b24 >> 18 & 0x3F;
            int c1 = b24 >> 12 & 0x3F;
            int c2 = b24 >> 6 & 0x3F;
            int c3 = b24 & 0x3F;
            chars[oidx++] = BASE_64_CHARS[c0];
            chars[oidx++] = BASE_64_CHARS[c1];
            chars[oidx++] = charsLeft > 1 ? BASE_64_CHARS[c2] : 61;
            chars[oidx++] = charsLeft > 2 ? BASE_64_CHARS[c3] : 61;
        }
        return new String(chars);
    }

    static {
        for (int i = 0; i < BASE_64_CHARS.length; ++i) {
            Base64Util.BASE_64_CHARS_LOOKUP[Base64Util.BASE_64_CHARS[i]] = (byte)i;
        }
    }
}

