/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.pay.server;

import com.badlogic.gdx.pay.Transaction;
import com.badlogic.gdx.pay.server.PurchaseVerifier;
import java.util.HashMap;
import java.util.Map;

public class PurchaseVerifierManager {
    private boolean defaultIfNoVerifierFound;
    private Map<String, PurchaseVerifier> verifiers;

    public PurchaseVerifierManager() {
        this(false);
    }

    public PurchaseVerifierManager(boolean defaultIfNoVerifierFound) {
        this.defaultIfNoVerifierFound = defaultIfNoVerifierFound;
        this.verifiers = new HashMap<String, PurchaseVerifier>(16);
    }

    public void addVerifier(PurchaseVerifier verifier) {
        this.verifiers.put(verifier.storeName(), verifier);
    }

    public void removeVerifier(PurchaseVerifier verifier) {
        this.verifiers.remove(verifier.storeName());
    }

    public boolean isValid(Transaction transaction) {
        PurchaseVerifier verifier = this.verifiers.get(transaction.getStoreName());
        if (verifier == null) {
            return this.defaultIfNoVerifierFound;
        }
        return verifier.isValid(transaction);
    }
}

