/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.stream.binder.servicebus;

import com.azure.spring.cloud.stream.binder.servicebus.ServiceBusMessageChannelBinder;
import com.azure.spring.integration.core.instrumentation.Instrumentation;
import com.azure.spring.integration.core.instrumentation.InstrumentationManager;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class ServiceBusHealthIndicator
extends AbstractHealthIndicator {
    private final InstrumentationManager instrumentationManager;

    public ServiceBusHealthIndicator(ServiceBusMessageChannelBinder binder) {
        super("Service bus health check failed");
        this.instrumentationManager = binder.getInstrumentationManager();
    }

    protected void doHealthCheck(Health.Builder builder) {
        if (this.instrumentationManager == null || this.instrumentationManager.getAllHealthInstrumentation().isEmpty()) {
            builder.unknown();
            return;
        }
        if (this.instrumentationManager.getAllHealthInstrumentation().stream().allMatch(instr -> Instrumentation.Status.UP == instr.getStatus())) {
            builder.up();
            return;
        }
        builder.down();
        this.instrumentationManager.getAllHealthInstrumentation().stream().filter(instr -> Instrumentation.Status.DOWN == instr.getStatus()).forEach(instr -> builder.withDetail(instr.getId(), (Object)instr.getException()));
    }
}

