/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.actuator.implementation.keyvault;

import com.azure.core.exception.ResourceNotFoundException;
import com.azure.security.keyvault.secrets.SecretAsyncClient;
import com.azure.spring.cloud.actuator.implementation.util.ActuateConstants;
import java.time.Duration;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class KeyVaultSecretHealthIndicator
extends AbstractHealthIndicator {
    private final SecretAsyncClient secretAsyncClient;
    private Duration timeout = ActuateConstants.DEFAULT_HEALTH_CHECK_TIMEOUT;

    public KeyVaultSecretHealthIndicator(SecretAsyncClient secretAsyncClient) {
        this.secretAsyncClient = secretAsyncClient;
    }

    protected void doHealthCheck(Health.Builder builder) {
        try {
            this.secretAsyncClient.getSecretWithResponse("spring-cloud-azure-not-existing-secret", "").block(this.timeout);
            builder.up();
        }
        catch (Exception e) {
            if (e instanceof ResourceNotFoundException) {
                builder.up();
            }
            throw e;
        }
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }
}

