/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.actuator.implementation.appconfiguration;

import com.azure.core.exception.ResourceNotFoundException;
import com.azure.data.appconfiguration.ConfigurationAsyncClient;
import com.azure.spring.cloud.actuator.implementation.util.ActuateConstants;
import java.time.Duration;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class AppConfigurationHealthIndicator
extends AbstractHealthIndicator {
    private Duration timeout = ActuateConstants.DEFAULT_HEALTH_CHECK_TIMEOUT;
    private final ConfigurationAsyncClient configurationAsyncClient;

    public AppConfigurationHealthIndicator(ConfigurationAsyncClient configurationAsyncClient) {
        this.configurationAsyncClient = configurationAsyncClient;
    }

    protected void doHealthCheck(Health.Builder builder) {
        try {
            this.configurationAsyncClient.getConfigurationSetting("spring-cloud-azure-not-existing-setting", null).block(this.timeout);
            builder.up();
        }
        catch (Exception e) {
            if (e instanceof ResourceNotFoundException) {
                builder.up();
            }
            throw e;
        }
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }
}

