// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.trafficmanager.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Class representing Traffic Manager User Metrics. */
@Fluent
public final class UserMetricsModelInner extends ProxyResource {
    /*
     * The properties of the Traffic Manager User Metrics.
     */
    @JsonProperty(value = "properties")
    private UserMetricsProperties innerProperties;

    /** Creates an instance of UserMetricsModelInner class. */
    public UserMetricsModelInner() {
    }

    /**
     * Get the innerProperties property: The properties of the Traffic Manager User Metrics.
     *
     * @return the innerProperties value.
     */
    private UserMetricsProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the key property: The key returned by the User Metrics operation.
     *
     * @return the key value.
     */
    public String key() {
        return this.innerProperties() == null ? null : this.innerProperties().key();
    }

    /**
     * Set the key property: The key returned by the User Metrics operation.
     *
     * @param key the key value to set.
     * @return the UserMetricsModelInner object itself.
     */
    public UserMetricsModelInner withKey(String key) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserMetricsProperties();
        }
        this.innerProperties().withKey(key);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
