/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.HttpProtocol;
import com.azure.resourcemanager.storage.models.Permissions;
import com.azure.resourcemanager.storage.models.Services;
import com.azure.resourcemanager.storage.models.SignedResourceTypes;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class AccountSasParameters
implements JsonSerializable<AccountSasParameters> {
    private Services services;
    private SignedResourceTypes resourceTypes;
    private Permissions permissions;
    private String ipAddressOrRange;
    private HttpProtocol protocols;
    private OffsetDateTime sharedAccessStartTime;
    private OffsetDateTime sharedAccessExpiryTime;
    private String keyToSign;
    private static final ClientLogger LOGGER = new ClientLogger(AccountSasParameters.class);

    public Services services() {
        return this.services;
    }

    public AccountSasParameters withServices(Services services) {
        this.services = services;
        return this;
    }

    public SignedResourceTypes resourceTypes() {
        return this.resourceTypes;
    }

    public AccountSasParameters withResourceTypes(SignedResourceTypes resourceTypes) {
        this.resourceTypes = resourceTypes;
        return this;
    }

    public Permissions permissions() {
        return this.permissions;
    }

    public AccountSasParameters withPermissions(Permissions permissions) {
        this.permissions = permissions;
        return this;
    }

    public String ipAddressOrRange() {
        return this.ipAddressOrRange;
    }

    public AccountSasParameters withIpAddressOrRange(String ipAddressOrRange) {
        this.ipAddressOrRange = ipAddressOrRange;
        return this;
    }

    public HttpProtocol protocols() {
        return this.protocols;
    }

    public AccountSasParameters withProtocols(HttpProtocol protocols) {
        this.protocols = protocols;
        return this;
    }

    public OffsetDateTime sharedAccessStartTime() {
        return this.sharedAccessStartTime;
    }

    public AccountSasParameters withSharedAccessStartTime(OffsetDateTime sharedAccessStartTime) {
        this.sharedAccessStartTime = sharedAccessStartTime;
        return this;
    }

    public OffsetDateTime sharedAccessExpiryTime() {
        return this.sharedAccessExpiryTime;
    }

    public AccountSasParameters withSharedAccessExpiryTime(OffsetDateTime sharedAccessExpiryTime) {
        this.sharedAccessExpiryTime = sharedAccessExpiryTime;
        return this;
    }

    public String keyToSign() {
        return this.keyToSign;
    }

    public AccountSasParameters withKeyToSign(String keyToSign) {
        this.keyToSign = keyToSign;
        return this;
    }

    public void validate() {
        if (this.services() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property services in model AccountSasParameters"));
        }
        if (this.resourceTypes() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resourceTypes in model AccountSasParameters"));
        }
        if (this.permissions() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property permissions in model AccountSasParameters"));
        }
        if (this.sharedAccessExpiryTime() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sharedAccessExpiryTime in model AccountSasParameters"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("signedServices", this.services == null ? null : this.services.toString());
        jsonWriter.writeStringField("signedResourceTypes", this.resourceTypes == null ? null : this.resourceTypes.toString());
        jsonWriter.writeStringField("signedPermission", this.permissions == null ? null : this.permissions.toString());
        jsonWriter.writeStringField("signedExpiry", this.sharedAccessExpiryTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.sharedAccessExpiryTime));
        jsonWriter.writeStringField("signedIp", this.ipAddressOrRange);
        jsonWriter.writeStringField("signedProtocol", this.protocols == null ? null : this.protocols.toString());
        jsonWriter.writeStringField("signedStart", this.sharedAccessStartTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.sharedAccessStartTime));
        jsonWriter.writeStringField("keyToSign", this.keyToSign);
        return jsonWriter.writeEndObject();
    }

    public static AccountSasParameters fromJson(JsonReader jsonReader) throws IOException {
        return (AccountSasParameters)jsonReader.readObject(reader -> {
            AccountSasParameters deserializedAccountSasParameters = new AccountSasParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("signedServices".equals(fieldName)) {
                    deserializedAccountSasParameters.services = Services.fromString(reader.getString());
                    continue;
                }
                if ("signedResourceTypes".equals(fieldName)) {
                    deserializedAccountSasParameters.resourceTypes = SignedResourceTypes.fromString(reader.getString());
                    continue;
                }
                if ("signedPermission".equals(fieldName)) {
                    deserializedAccountSasParameters.permissions = Permissions.fromString(reader.getString());
                    continue;
                }
                if ("signedExpiry".equals(fieldName)) {
                    deserializedAccountSasParameters.sharedAccessExpiryTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("signedIp".equals(fieldName)) {
                    deserializedAccountSasParameters.ipAddressOrRange = reader.getString();
                    continue;
                }
                if ("signedProtocol".equals(fieldName)) {
                    deserializedAccountSasParameters.protocols = HttpProtocol.fromString(reader.getString());
                    continue;
                }
                if ("signedStart".equals(fieldName)) {
                    deserializedAccountSasParameters.sharedAccessStartTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("keyToSign".equals(fieldName)) {
                    deserializedAccountSasParameters.keyToSign = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAccountSasParameters;
        });
    }
}

