/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.ManagementPolicyBaseBlob;
import com.azure.resourcemanager.storage.models.ManagementPolicySnapShot;
import com.azure.resourcemanager.storage.models.ManagementPolicyVersion;
import java.io.IOException;

public final class ManagementPolicyAction
implements JsonSerializable<ManagementPolicyAction> {
    private ManagementPolicyBaseBlob baseBlob;
    private ManagementPolicySnapShot snapshot;
    private ManagementPolicyVersion version;

    public ManagementPolicyBaseBlob baseBlob() {
        return this.baseBlob;
    }

    public ManagementPolicyAction withBaseBlob(ManagementPolicyBaseBlob baseBlob) {
        this.baseBlob = baseBlob;
        return this;
    }

    public ManagementPolicySnapShot snapshot() {
        return this.snapshot;
    }

    public ManagementPolicyAction withSnapshot(ManagementPolicySnapShot snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public ManagementPolicyVersion version() {
        return this.version;
    }

    public ManagementPolicyAction withVersion(ManagementPolicyVersion version) {
        this.version = version;
        return this;
    }

    public void validate() {
        if (this.baseBlob() != null) {
            this.baseBlob().validate();
        }
        if (this.snapshot() != null) {
            this.snapshot().validate();
        }
        if (this.version() != null) {
            this.version().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("baseBlob", (JsonSerializable)this.baseBlob);
        jsonWriter.writeJsonField("snapshot", (JsonSerializable)this.snapshot);
        jsonWriter.writeJsonField("version", (JsonSerializable)this.version);
        return jsonWriter.writeEndObject();
    }

    public static ManagementPolicyAction fromJson(JsonReader jsonReader) throws IOException {
        return (ManagementPolicyAction)jsonReader.readObject(reader -> {
            ManagementPolicyAction deserializedManagementPolicyAction = new ManagementPolicyAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("baseBlob".equals(fieldName)) {
                    deserializedManagementPolicyAction.baseBlob = ManagementPolicyBaseBlob.fromJson(reader);
                    continue;
                }
                if ("snapshot".equals(fieldName)) {
                    deserializedManagementPolicyAction.snapshot = ManagementPolicySnapShot.fromJson(reader);
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedManagementPolicyAction.version = ManagementPolicyVersion.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagementPolicyAction;
        });
    }
}

