/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class CustomDomain
implements JsonSerializable<CustomDomain> {
    private String name;
    private Boolean useSubDomainName;
    private static final ClientLogger LOGGER = new ClientLogger(CustomDomain.class);

    public String name() {
        return this.name;
    }

    public CustomDomain withName(String name) {
        this.name = name;
        return this;
    }

    public Boolean useSubDomainName() {
        return this.useSubDomainName;
    }

    public CustomDomain withUseSubDomainName(Boolean useSubDomainName) {
        this.useSubDomainName = useSubDomainName;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model CustomDomain"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeBooleanField("useSubDomainName", this.useSubDomainName);
        return jsonWriter.writeEndObject();
    }

    public static CustomDomain fromJson(JsonReader jsonReader) throws IOException {
        return (CustomDomain)jsonReader.readObject(reader -> {
            CustomDomain deserializedCustomDomain = new CustomDomain();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedCustomDomain.name = reader.getString();
                    continue;
                }
                if ("useSubDomainName".equals(fieldName)) {
                    deserializedCustomDomain.useSubDomainName = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomDomain;
        });
    }
}

