/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.SyncFullSchemaPropertiesInner;
import com.azure.resourcemanager.sql.fluent.models.SyncMemberInner;
import com.azure.resourcemanager.sql.implementation.SqlSyncFullSchemaPropertyImpl;
import com.azure.resourcemanager.sql.implementation.SqlSyncGroupImpl;
import com.azure.resourcemanager.sql.models.SqlDatabase;
import com.azure.resourcemanager.sql.models.SqlSyncFullSchemaProperty;
import com.azure.resourcemanager.sql.models.SqlSyncGroup;
import com.azure.resourcemanager.sql.models.SqlSyncMember;
import com.azure.resourcemanager.sql.models.SqlSyncMemberOperations;
import com.azure.resourcemanager.sql.models.SyncDirection;
import com.azure.resourcemanager.sql.models.SyncMemberDbType;
import com.azure.resourcemanager.sql.models.SyncMemberState;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class SqlSyncMemberImpl
extends ExternalChildResourceImpl<SqlSyncMember, SyncMemberInner, SqlSyncGroupImpl, SqlSyncGroup>
implements SqlSyncMember,
SqlSyncMember.Update,
SqlSyncMemberOperations.SqlSyncMemberOperationsDefinition {
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;
    private String sqlDatabaseName;
    private String sqlSyncGroupName;

    SqlSyncMemberImpl(String name, SqlSyncGroupImpl parent, SyncMemberInner innerObject, SqlServerManager sqlServerManager) {
        super(name, (Object)parent, (Object)innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.sqlServerName();
        this.sqlDatabaseName = parent.sqlDatabaseName();
        this.sqlSyncGroupName = parent.name();
    }

    SqlSyncMemberImpl(String resourceGroupName, String sqlServerName, String sqlDatabaseName, String sqlSyncGroupName, String name, SyncMemberInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlDatabaseName = sqlDatabaseName;
        this.sqlSyncGroupName = sqlSyncGroupName;
    }

    SqlSyncMemberImpl(String name, SyncMemberInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        if (innerObject != null && innerObject.id() != null) {
            try {
                ResourceId resourceId = ResourceId.fromString((String)innerObject.id());
                this.resourceGroupName = resourceId.resourceGroupName();
                this.sqlServerName = resourceId.parent().parent().parent().name();
                this.sqlDatabaseName = resourceId.parent().parent().name();
                this.sqlSyncGroupName = resourceId.parent().name();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    public String id() {
        return ((SyncMemberInner)((Object)this.innerModel())).id();
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String sqlDatabaseName() {
        return this.sqlDatabaseName;
    }

    @Override
    public String sqlSyncGroupName() {
        return this.sqlSyncGroupName;
    }

    @Override
    public String parentId() {
        return ResourceUtils.parentResourceIdFromResourceId((String)((SyncMemberInner)((Object)this.innerModel())).id());
    }

    @Override
    public SyncMemberDbType databaseType() {
        return ((SyncMemberInner)((Object)this.innerModel())).databaseType();
    }

    @Override
    public String syncAgentId() {
        return ((SyncMemberInner)((Object)this.innerModel())).syncAgentId();
    }

    @Override
    public String sqlServerDatabaseId() {
        return ((SyncMemberInner)((Object)this.innerModel())).sqlServerDatabaseId().toString();
    }

    @Override
    public String memberServerName() {
        return ((SyncMemberInner)((Object)this.innerModel())).serverName();
    }

    @Override
    public String memberDatabaseName() {
        return ((SyncMemberInner)((Object)this.innerModel())).databaseName();
    }

    @Override
    public String username() {
        return ((SyncMemberInner)((Object)this.innerModel())).username();
    }

    @Override
    public SyncDirection syncDirection() {
        return ((SyncMemberInner)((Object)this.innerModel())).syncDirection();
    }

    @Override
    public SyncMemberState syncState() {
        return ((SyncMemberInner)((Object)this.innerModel())).syncState();
    }

    public Mono<SqlSyncMember> createResourceAsync() {
        SqlSyncMemberImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncMembers().createOrUpdateAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.sqlSyncGroupName, this.name(), (SyncMemberInner)((Object)this.innerModel())).map(syncMemberInner -> {
            self.setInner(syncMemberInner);
            return self;
        });
    }

    public Mono<SqlSyncMember> updateResourceAsync() {
        return this.createResourceAsync();
    }

    public Mono<Void> deleteResourceAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncMembers().deleteAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.sqlSyncGroupName, this.name());
    }

    protected Mono<SyncMemberInner> getInnerAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncMembers().getAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.sqlSyncGroupName, this.name());
    }

    @Override
    public void delete() {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncMembers().delete(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.sqlSyncGroupName, this.name());
    }

    @Override
    public Mono<Void> deleteAsync() {
        return this.deleteResourceAsync();
    }

    public SqlSyncMember.Update update() {
        this.setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeUpdated);
        return this;
    }

    @Override
    public PagedIterable<SqlSyncFullSchemaProperty> listMemberSchemas() {
        return PagedConverter.mapPage(((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncMembers().listMemberSchemas(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.sqlSyncGroupName, this.name()), inner -> new SqlSyncFullSchemaPropertyImpl((SyncFullSchemaPropertiesInner)inner));
    }

    @Override
    public PagedFlux<SqlSyncFullSchemaProperty> listMemberSchemasAsync() {
        return PagedConverter.mapPage(((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncMembers().listMemberSchemasAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.sqlSyncGroupName, this.name()), syncFullSchemaPropertiesInner -> new SqlSyncFullSchemaPropertyImpl((SyncFullSchemaPropertiesInner)syncFullSchemaPropertiesInner));
    }

    @Override
    public void refreshMemberSchema() {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncMembers().refreshMemberSchema(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.sqlSyncGroupName, this.name());
    }

    @Override
    public Mono<Void> refreshMemberSchemaAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncMembers().refreshMemberSchemaAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.sqlSyncGroupName, this.name());
    }

    @Override
    public SqlSyncMemberImpl withExistingSqlServer(String resourceGroupName, String sqlServerName) {
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        return this;
    }

    @Override
    public SqlSyncMemberImpl withExistingSyncGroup(SqlSyncGroup sqlSyncGroup) {
        this.resourceGroupName = sqlSyncGroup.resourceGroupName();
        this.sqlServerName = sqlSyncGroup.sqlServerName();
        this.sqlDatabaseName = sqlSyncGroup.sqlDatabaseName();
        this.sqlSyncGroupName = sqlSyncGroup.name();
        return this;
    }

    @Override
    public SqlSyncMemberImpl withExistingDatabaseName(String databaseName) {
        this.sqlDatabaseName = databaseName;
        return this;
    }

    @Override
    public SqlSyncMemberImpl withMemberUserName(String userName) {
        ((SyncMemberInner)((Object)this.innerModel())).withUsername(userName);
        return this;
    }

    @Override
    public SqlSyncMemberImpl withExistingSyncGroupName(String syncGroupName) {
        this.sqlSyncGroupName = syncGroupName;
        return this;
    }

    @Override
    public SqlSyncMemberImpl withMemberPassword(String password) {
        ((SyncMemberInner)((Object)this.innerModel())).withPassword(password);
        return this;
    }

    @Override
    public SqlSyncMemberImpl withMemberSqlServerName(String sqlServerName) {
        ((SyncMemberInner)((Object)this.innerModel())).withServerName(sqlServerName);
        return this;
    }

    @Override
    public SqlSyncMemberImpl withMemberSqlDatabase(SqlDatabase sqlDatabase) {
        ((SyncMemberInner)((Object)this.innerModel())).withServerName(sqlDatabase.sqlServerName());
        ((SyncMemberInner)((Object)this.innerModel())).withDatabaseName(sqlDatabase.name());
        return this;
    }

    @Override
    public SqlSyncMemberImpl withMemberDatabaseType(SyncMemberDbType databaseType) {
        ((SyncMemberInner)((Object)this.innerModel())).withDatabaseType(databaseType);
        return this;
    }

    @Override
    public SqlSyncMemberImpl withDatabaseType(SyncDirection syncDirection) {
        ((SyncMemberInner)((Object)this.innerModel())).withSyncDirection(syncDirection);
        return this;
    }

    @Override
    public SqlSyncMemberImpl withMemberSqlDatabaseName(String sqlDatabaseName) {
        ((SyncMemberInner)((Object)this.innerModel())).withDatabaseName(sqlDatabaseName);
        return this;
    }
}

