/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.management.Region;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.EncryptionProtectorInner;
import com.azure.resourcemanager.sql.implementation.SqlServerImpl;
import com.azure.resourcemanager.sql.models.EncryptionProtectorName;
import com.azure.resourcemanager.sql.models.ServerKeyType;
import com.azure.resourcemanager.sql.models.SqlEncryptionProtector;
import com.azure.resourcemanager.sql.models.SqlServer;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class SqlEncryptionProtectorImpl
extends ExternalChildResourceImpl<SqlEncryptionProtector, EncryptionProtectorInner, SqlServerImpl, SqlServer>
implements SqlEncryptionProtector,
SqlEncryptionProtector.Update {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;
    private String serverKeyName;

    SqlEncryptionProtectorImpl(SqlServerImpl parent, EncryptionProtectorInner innerObject, SqlServerManager sqlServerManager) {
        super("", (Object)parent, (Object)innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.name();
        if (innerObject != null && innerObject.name() != null) {
            this.serverKeyName = innerObject.name();
        }
    }

    SqlEncryptionProtectorImpl(String resourceGroupName, String sqlServerName, EncryptionProtectorInner innerObject, SqlServerManager sqlServerManager) {
        super("", null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        if (innerObject != null && innerObject.name() != null) {
            this.serverKeyName = innerObject.name();
        }
    }

    SqlEncryptionProtectorImpl(EncryptionProtectorInner innerObject, SqlServerManager sqlServerManager) {
        super("", null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        if (innerObject != null && innerObject.id() != null) {
            if (innerObject.name() != null) {
                this.serverKeyName = innerObject.name();
            }
            try {
                ResourceId resourceId = ResourceId.fromString((String)innerObject.id());
                this.resourceGroupName = resourceId.resourceGroupName();
                this.sqlServerName = resourceId.parent().name();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public String id() {
        return ((EncryptionProtectorInner)((Object)this.innerModel())).id();
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String sqlServerName() {
        return this.serverKeyName;
    }

    @Override
    public String parentId() {
        return ResourceUtils.parentResourceIdFromResourceId((String)((EncryptionProtectorInner)((Object)this.innerModel())).id());
    }

    @Override
    public String kind() {
        return ((EncryptionProtectorInner)((Object)this.innerModel())).kind();
    }

    @Override
    public Region region() {
        return Region.fromName((String)((EncryptionProtectorInner)((Object)this.innerModel())).location());
    }

    @Override
    public String serverKeyName() {
        return ((EncryptionProtectorInner)((Object)this.innerModel())).serverKeyName();
    }

    @Override
    public ServerKeyType serverKeyType() {
        return ((EncryptionProtectorInner)((Object)this.innerModel())).serverKeyType();
    }

    @Override
    public String uri() {
        return ((EncryptionProtectorInner)((Object)this.innerModel())).uri();
    }

    @Override
    public String thumbprint() {
        return ((EncryptionProtectorInner)((Object)this.innerModel())).thumbprint();
    }

    @Override
    public SqlEncryptionProtectorImpl withAzureKeyVaultServerKey(String serverKeyName) {
        ((EncryptionProtectorInner)((Object)this.innerModel())).withServerKeyName(serverKeyName);
        ((EncryptionProtectorInner)((Object)this.innerModel())).withServerKeyType(ServerKeyType.AZURE_KEY_VAULT);
        return this;
    }

    @Override
    public SqlEncryptionProtectorImpl withServiceManagedServerKey() {
        ((EncryptionProtectorInner)((Object)this.innerModel())).withServerKeyName("ServiceManaged");
        ((EncryptionProtectorInner)((Object)this.innerModel())).withServerKeyType(ServerKeyType.SERVICE_MANAGED);
        return this;
    }

    public Mono<SqlEncryptionProtector> createResourceAsync() {
        SqlEncryptionProtectorImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getEncryptionProtectors().createOrUpdateAsync(this.resourceGroupName, this.sqlServerName, EncryptionProtectorName.CURRENT, (EncryptionProtectorInner)((Object)this.innerModel())).map(encryptionProtectorInner -> {
            self.setInner(encryptionProtectorInner);
            return self;
        });
    }

    public SqlEncryptionProtectorImpl update() {
        return this;
    }

    public Mono<SqlEncryptionProtector> updateResourceAsync() {
        return this.createResourceAsync();
    }

    public Mono<Void> deleteResourceAsync() {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Delete operation not supported"));
    }

    protected Mono<EncryptionProtectorInner> getInnerAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getEncryptionProtectors().getAsync(this.resourceGroupName, this.sqlServerName, EncryptionProtectorName.CURRENT);
    }
}

