/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.FailoverGroupReadOnlyEndpoint;
import com.azure.resourcemanager.sql.models.FailoverGroupReadWriteEndpoint;
import java.io.IOException;
import java.util.List;

public final class FailoverGroupUpdateProperties
implements JsonSerializable<FailoverGroupUpdateProperties> {
    private FailoverGroupReadWriteEndpoint readWriteEndpoint;
    private FailoverGroupReadOnlyEndpoint readOnlyEndpoint;
    private List<String> databases;

    public FailoverGroupReadWriteEndpoint readWriteEndpoint() {
        return this.readWriteEndpoint;
    }

    public FailoverGroupUpdateProperties withReadWriteEndpoint(FailoverGroupReadWriteEndpoint readWriteEndpoint) {
        this.readWriteEndpoint = readWriteEndpoint;
        return this;
    }

    public FailoverGroupReadOnlyEndpoint readOnlyEndpoint() {
        return this.readOnlyEndpoint;
    }

    public FailoverGroupUpdateProperties withReadOnlyEndpoint(FailoverGroupReadOnlyEndpoint readOnlyEndpoint) {
        this.readOnlyEndpoint = readOnlyEndpoint;
        return this;
    }

    public List<String> databases() {
        return this.databases;
    }

    public FailoverGroupUpdateProperties withDatabases(List<String> databases) {
        this.databases = databases;
        return this;
    }

    public void validate() {
        if (this.readWriteEndpoint() != null) {
            this.readWriteEndpoint().validate();
        }
        if (this.readOnlyEndpoint() != null) {
            this.readOnlyEndpoint().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("readWriteEndpoint", (JsonSerializable)this.readWriteEndpoint);
        jsonWriter.writeJsonField("readOnlyEndpoint", (JsonSerializable)this.readOnlyEndpoint);
        jsonWriter.writeArrayField("databases", this.databases, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static FailoverGroupUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (FailoverGroupUpdateProperties)jsonReader.readObject(reader -> {
            FailoverGroupUpdateProperties deserializedFailoverGroupUpdateProperties = new FailoverGroupUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("readWriteEndpoint".equals(fieldName)) {
                    deserializedFailoverGroupUpdateProperties.readWriteEndpoint = FailoverGroupReadWriteEndpoint.fromJson(reader);
                    continue;
                }
                if ("readOnlyEndpoint".equals(fieldName)) {
                    deserializedFailoverGroupUpdateProperties.readOnlyEndpoint = FailoverGroupReadOnlyEndpoint.fromJson(reader);
                    continue;
                }
                if ("databases".equals(fieldName)) {
                    List databases;
                    deserializedFailoverGroupUpdateProperties.databases = databases = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFailoverGroupUpdateProperties;
        });
    }
}

