/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.servicebus.fluent.models.SBQueueInner;
import java.io.IOException;
import java.util.List;

public final class SBQueueListResult
implements JsonSerializable<SBQueueListResult> {
    private List<SBQueueInner> value;
    private String nextLink;

    public List<SBQueueInner> value() {
        return this.value;
    }

    public SBQueueListResult withValue(List<SBQueueInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public SBQueueListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static SBQueueListResult fromJson(JsonReader jsonReader) throws IOException {
        return (SBQueueListResult)jsonReader.readObject(reader -> {
            SBQueueListResult deserializedSBQueueListResult = new SBQueueListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedSBQueueListResult.value = value = reader.readArray(reader1 -> SBQueueInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedSBQueueListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSBQueueListResult;
        });
    }
}

