/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.models;

import com.azure.resourcemanager.servicebus.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.servicebus.fluent.models.SBNamespaceUpdateProperties;
import com.azure.resourcemanager.servicebus.models.Encryption;
import com.azure.resourcemanager.servicebus.models.Identity;
import com.azure.resourcemanager.servicebus.models.ResourceNamespacePatch;
import com.azure.resourcemanager.servicebus.models.SBSku;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class SBNamespaceUpdateParameters
extends ResourceNamespacePatch {
    @JsonProperty(value="sku")
    private SBSku sku;
    @JsonProperty(value="properties")
    private SBNamespaceUpdateProperties innerProperties;
    @JsonProperty(value="identity")
    private Identity identity;

    public SBSku sku() {
        return this.sku;
    }

    public SBNamespaceUpdateParameters withSku(SBSku sku) {
        this.sku = sku;
        return this;
    }

    private SBNamespaceUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public Identity identity() {
        return this.identity;
    }

    public SBNamespaceUpdateParameters withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    @Override
    public SBNamespaceUpdateParameters withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public SBNamespaceUpdateParameters withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public OffsetDateTime createdAt() {
        return this.innerProperties() == null ? null : this.innerProperties().createdAt();
    }

    public OffsetDateTime updatedAt() {
        return this.innerProperties() == null ? null : this.innerProperties().updatedAt();
    }

    public String serviceBusEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceBusEndpoint();
    }

    public String metricId() {
        return this.innerProperties() == null ? null : this.innerProperties().metricId();
    }

    public Encryption encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    public SBNamespaceUpdateParameters withEncryption(Encryption encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBNamespaceUpdateProperties();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public SBNamespaceUpdateParameters withPrivateEndpointConnections(List<PrivateEndpointConnectionInner> privateEndpointConnections) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBNamespaceUpdateProperties();
        }
        this.innerProperties().withPrivateEndpointConnections(privateEndpointConnections);
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.innerProperties() == null ? null : this.innerProperties().disableLocalAuth();
    }

    public SBNamespaceUpdateParameters withDisableLocalAuth(Boolean disableLocalAuth) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBNamespaceUpdateProperties();
        }
        this.innerProperties().withDisableLocalAuth(disableLocalAuth);
        return this;
    }

    public String alternateName() {
        return this.innerProperties() == null ? null : this.innerProperties().alternateName();
    }

    public SBNamespaceUpdateParameters withAlternateName(String alternateName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBNamespaceUpdateProperties();
        }
        this.innerProperties().withAlternateName(alternateName);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }
}

