// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicebus.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.servicebus.fluent.models.SBNamespaceInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The response of the List Namespace operation. */
@Fluent
public final class SBNamespaceListResult {
    /*
     * Result of the List Namespace operation.
     */
    @JsonProperty(value = "value")
    private List<SBNamespaceInner> value;

    /*
     * Link to the next set of results. Not empty if Value contains incomplete list of Namespaces.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Get the value property: Result of the List Namespace operation.
     *
     * @return the value value.
     */
    public List<SBNamespaceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Result of the List Namespace operation.
     *
     * @param value the value value to set.
     * @return the SBNamespaceListResult object itself.
     */
    public SBNamespaceListResult withValue(List<SBNamespaceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Link to the next set of results. Not empty if Value contains incomplete list of
     * Namespaces.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Link to the next set of results. Not empty if Value contains incomplete list of
     * Namespaces.
     *
     * @param nextLink the nextLink value to set.
     * @return the SBNamespaceListResult object itself.
     */
    public SBNamespaceListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
