// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicebus.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.resourcemanager.servicebus.models.Action;
import com.azure.resourcemanager.servicebus.models.CorrelationFilter;
import com.azure.resourcemanager.servicebus.models.FilterType;
import com.azure.resourcemanager.servicebus.models.SqlFilter;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Description of Rule Resource. */
@Fluent
public final class RuleInner extends ProxyResource {
    /*
     * Properties of Rule resource
     */
    @JsonProperty(value = "properties")
    private Ruleproperties innerProperties;

    /*
     * The system meta data relating to this resource.
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /*
     * The geo-location where the resource lives
     */
    @JsonProperty(value = "location", access = JsonProperty.Access.WRITE_ONLY)
    private String location;

    /**
     * Get the innerProperties property: Properties of Rule resource.
     *
     * @return the innerProperties value.
     */
    private Ruleproperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: The system meta data relating to this resource.
     *
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the location property: The geo-location where the resource lives.
     *
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the action property: Represents the filter actions which are allowed for the transformation of a message that
     * have been matched by a filter expression.
     *
     * @return the action value.
     */
    public Action action() {
        return this.innerProperties() == null ? null : this.innerProperties().action();
    }

    /**
     * Set the action property: Represents the filter actions which are allowed for the transformation of a message that
     * have been matched by a filter expression.
     *
     * @param action the action value to set.
     * @return the RuleInner object itself.
     */
    public RuleInner withAction(Action action) {
        if (this.innerProperties() == null) {
            this.innerProperties = new Ruleproperties();
        }
        this.innerProperties().withAction(action);
        return this;
    }

    /**
     * Get the filterType property: Filter type that is evaluated against a BrokeredMessage.
     *
     * @return the filterType value.
     */
    public FilterType filterType() {
        return this.innerProperties() == null ? null : this.innerProperties().filterType();
    }

    /**
     * Set the filterType property: Filter type that is evaluated against a BrokeredMessage.
     *
     * @param filterType the filterType value to set.
     * @return the RuleInner object itself.
     */
    public RuleInner withFilterType(FilterType filterType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new Ruleproperties();
        }
        this.innerProperties().withFilterType(filterType);
        return this;
    }

    /**
     * Get the sqlFilter property: Properties of sqlFilter.
     *
     * @return the sqlFilter value.
     */
    public SqlFilter sqlFilter() {
        return this.innerProperties() == null ? null : this.innerProperties().sqlFilter();
    }

    /**
     * Set the sqlFilter property: Properties of sqlFilter.
     *
     * @param sqlFilter the sqlFilter value to set.
     * @return the RuleInner object itself.
     */
    public RuleInner withSqlFilter(SqlFilter sqlFilter) {
        if (this.innerProperties() == null) {
            this.innerProperties = new Ruleproperties();
        }
        this.innerProperties().withSqlFilter(sqlFilter);
        return this;
    }

    /**
     * Get the correlationFilter property: Properties of correlationFilter.
     *
     * @return the correlationFilter value.
     */
    public CorrelationFilter correlationFilter() {
        return this.innerProperties() == null ? null : this.innerProperties().correlationFilter();
    }

    /**
     * Set the correlationFilter property: Properties of correlationFilter.
     *
     * @param correlationFilter the correlationFilter value to set.
     * @return the RuleInner object itself.
     */
    public RuleInner withCorrelationFilter(CorrelationFilter correlationFilter) {
        if (this.innerProperties() == null) {
            this.innerProperties = new Ruleproperties();
        }
        this.innerProperties().withCorrelationFilter(correlationFilter);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
