/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.AuthorizationProfile;
import com.azure.resourcemanager.resources.models.SubscriptionFeatureRegistrationApprovalType;
import com.azure.resourcemanager.resources.models.SubscriptionFeatureRegistrationState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class SubscriptionFeatureRegistrationProperties
implements JsonSerializable<SubscriptionFeatureRegistrationProperties> {
    private String tenantId;
    private String subscriptionId;
    private String featureName;
    private String displayName;
    private String providerNamespace;
    private SubscriptionFeatureRegistrationState state;
    private AuthorizationProfile authorizationProfile;
    private Map<String, String> metadata;
    private OffsetDateTime releaseDate;
    private OffsetDateTime registrationDate;
    private String documentationLink;
    private SubscriptionFeatureRegistrationApprovalType approvalType;
    private Boolean shouldFeatureDisplayInPortal;
    private String description;

    public String tenantId() {
        return this.tenantId;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public String featureName() {
        return this.featureName;
    }

    public String displayName() {
        return this.displayName;
    }

    public String providerNamespace() {
        return this.providerNamespace;
    }

    public SubscriptionFeatureRegistrationState state() {
        return this.state;
    }

    public SubscriptionFeatureRegistrationProperties withState(SubscriptionFeatureRegistrationState state) {
        this.state = state;
        return this;
    }

    public AuthorizationProfile authorizationProfile() {
        return this.authorizationProfile;
    }

    public SubscriptionFeatureRegistrationProperties withAuthorizationProfile(AuthorizationProfile authorizationProfile) {
        this.authorizationProfile = authorizationProfile;
        return this;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public SubscriptionFeatureRegistrationProperties withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public OffsetDateTime releaseDate() {
        return this.releaseDate;
    }

    public OffsetDateTime registrationDate() {
        return this.registrationDate;
    }

    public String documentationLink() {
        return this.documentationLink;
    }

    public SubscriptionFeatureRegistrationApprovalType approvalType() {
        return this.approvalType;
    }

    public Boolean shouldFeatureDisplayInPortal() {
        return this.shouldFeatureDisplayInPortal;
    }

    public SubscriptionFeatureRegistrationProperties withShouldFeatureDisplayInPortal(Boolean shouldFeatureDisplayInPortal) {
        this.shouldFeatureDisplayInPortal = shouldFeatureDisplayInPortal;
        return this;
    }

    public String description() {
        return this.description;
    }

    public SubscriptionFeatureRegistrationProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
        if (this.authorizationProfile() != null) {
            this.authorizationProfile().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeJsonField("authorizationProfile", (JsonSerializable)this.authorizationProfile);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("shouldFeatureDisplayInPortal", this.shouldFeatureDisplayInPortal);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static SubscriptionFeatureRegistrationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SubscriptionFeatureRegistrationProperties)jsonReader.readObject(reader -> {
            SubscriptionFeatureRegistrationProperties deserializedSubscriptionFeatureRegistrationProperties = new SubscriptionFeatureRegistrationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tenantId".equals(fieldName)) {
                    deserializedSubscriptionFeatureRegistrationProperties.tenantId = reader.getString();
                    continue;
                }
                if ("subscriptionId".equals(fieldName)) {
                    deserializedSubscriptionFeatureRegistrationProperties.subscriptionId = reader.getString();
                    continue;
                }
                if ("featureName".equals(fieldName)) {
                    deserializedSubscriptionFeatureRegistrationProperties.featureName = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedSubscriptionFeatureRegistrationProperties.displayName = reader.getString();
                    continue;
                }
                if ("providerNamespace".equals(fieldName)) {
                    deserializedSubscriptionFeatureRegistrationProperties.providerNamespace = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedSubscriptionFeatureRegistrationProperties.state = SubscriptionFeatureRegistrationState.fromString(reader.getString());
                    continue;
                }
                if ("authorizationProfile".equals(fieldName)) {
                    deserializedSubscriptionFeatureRegistrationProperties.authorizationProfile = AuthorizationProfile.fromJson(reader);
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedSubscriptionFeatureRegistrationProperties.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("releaseDate".equals(fieldName)) {
                    deserializedSubscriptionFeatureRegistrationProperties.releaseDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("registrationDate".equals(fieldName)) {
                    deserializedSubscriptionFeatureRegistrationProperties.registrationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("documentationLink".equals(fieldName)) {
                    deserializedSubscriptionFeatureRegistrationProperties.documentationLink = reader.getString();
                    continue;
                }
                if ("approvalType".equals(fieldName)) {
                    deserializedSubscriptionFeatureRegistrationProperties.approvalType = SubscriptionFeatureRegistrationApprovalType.fromString(reader.getString());
                    continue;
                }
                if ("shouldFeatureDisplayInPortal".equals(fieldName)) {
                    deserializedSubscriptionFeatureRegistrationProperties.shouldFeatureDisplayInPortal = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSubscriptionFeatureRegistrationProperties.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSubscriptionFeatureRegistrationProperties;
        });
    }
}

