/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.DeploymentWhatIfProperties;
import java.io.IOException;

public final class ScopedDeploymentWhatIf
implements JsonSerializable<ScopedDeploymentWhatIf> {
    private String location;
    private DeploymentWhatIfProperties properties;
    private static final ClientLogger LOGGER = new ClientLogger(ScopedDeploymentWhatIf.class);

    public String location() {
        return this.location;
    }

    public ScopedDeploymentWhatIf withLocation(String location) {
        this.location = location;
        return this;
    }

    public DeploymentWhatIfProperties properties() {
        return this.properties;
    }

    public ScopedDeploymentWhatIf withProperties(DeploymentWhatIfProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model ScopedDeploymentWhatIf"));
        }
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model ScopedDeploymentWhatIf"));
        }
        this.properties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static ScopedDeploymentWhatIf fromJson(JsonReader jsonReader) throws IOException {
        return (ScopedDeploymentWhatIf)jsonReader.readObject(reader -> {
            ScopedDeploymentWhatIf deserializedScopedDeploymentWhatIf = new ScopedDeploymentWhatIf();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedScopedDeploymentWhatIf.location = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedScopedDeploymentWhatIf.properties = DeploymentWhatIfProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScopedDeploymentWhatIf;
        });
    }
}

