/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.implementation;

import com.azure.resourcemanager.redis.RedisManager;
import com.azure.resourcemanager.redis.fluent.RedisManagementClient;
import com.azure.resourcemanager.redis.fluent.models.RedisPatchScheduleInner;
import com.azure.resourcemanager.redis.implementation.RedisCacheImpl;
import com.azure.resourcemanager.redis.models.DefaultName;
import com.azure.resourcemanager.redis.models.RedisCache;
import com.azure.resourcemanager.redis.models.RedisPatchSchedule;
import com.azure.resourcemanager.redis.models.ScheduleEntry;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import java.util.Collections;
import java.util.List;
import reactor.core.publisher.Mono;

class RedisPatchScheduleImpl
extends ExternalChildResourceImpl<RedisPatchSchedule, RedisPatchScheduleInner, RedisCacheImpl, RedisCache>
implements RedisPatchSchedule {
    RedisPatchScheduleImpl(String name, RedisCacheImpl parent, RedisPatchScheduleInner innerObject) {
        super(RedisPatchScheduleImpl.getChildName(name, parent.name()), (Object)parent, (Object)innerObject);
    }

    public String id() {
        return ((RedisPatchScheduleInner)((Object)this.innerModel())).id();
    }

    @Override
    public List<ScheduleEntry> scheduleEntries() {
        return Collections.unmodifiableList(((RedisPatchScheduleInner)((Object)this.innerModel())).scheduleEntries());
    }

    public Mono<RedisPatchSchedule> createResourceAsync() {
        RedisPatchScheduleImpl self = this;
        return ((RedisManagementClient)((RedisManager)((RedisCacheImpl)this.parent()).manager()).serviceClient()).getPatchSchedules().createOrUpdateAsync(((RedisCacheImpl)this.parent()).resourceGroupName(), ((RedisCacheImpl)this.parent()).name(), DefaultName.DEFAULT, ((RedisPatchScheduleInner)((Object)this.innerModel())).scheduleEntries()).map(patchScheduleInner -> {
            self.setInner(patchScheduleInner);
            return self;
        });
    }

    public Mono<RedisPatchSchedule> updateResourceAsync() {
        return this.createResourceAsync();
    }

    public Mono<Void> deleteResourceAsync() {
        return ((RedisManagementClient)((RedisManager)((RedisCacheImpl)this.parent()).manager()).serviceClient()).getPatchSchedules().deleteAsync(((RedisCacheImpl)this.parent()).resourceGroupName(), ((RedisCacheImpl)this.parent()).name(), DefaultName.DEFAULT);
    }

    protected Mono<RedisPatchScheduleInner> getInnerAsync() {
        return ((RedisManagementClient)((RedisManager)((RedisCacheImpl)this.parent()).manager()).serviceClient()).getPatchSchedules().getAsync(((RedisCacheImpl)this.parent()).resourceGroupName(), ((RedisCacheImpl)this.parent()).name(), DefaultName.DEFAULT);
    }

    private static String getChildName(String name, String parentName) {
        if (name != null && name.contains("/")) {
            return name.substring(parentName.length() + 1);
        }
        return name;
    }
}

