// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redis.fluent.models.RedisPatchScheduleInner;
import java.io.IOException;
import java.util.List;

/**
 * The response of list patch schedules Redis operation.
 */
@Fluent
public final class RedisPatchScheduleListResult implements JsonSerializable<RedisPatchScheduleListResult> {
    /*
     * Results of the list patch schedules operation.
     */
    private List<RedisPatchScheduleInner> value;

    /*
     * Link for next page of results.
     */
    private String nextLink;

    /**
     * Creates an instance of RedisPatchScheduleListResult class.
     */
    public RedisPatchScheduleListResult() {
    }

    /**
     * Get the value property: Results of the list patch schedules operation.
     * 
     * @return the value value.
     */
    public List<RedisPatchScheduleInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Results of the list patch schedules operation.
     * 
     * @param value the value value to set.
     * @return the RedisPatchScheduleListResult object itself.
     */
    public RedisPatchScheduleListResult withValue(List<RedisPatchScheduleInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Link for next page of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RedisPatchScheduleListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RedisPatchScheduleListResult if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RedisPatchScheduleListResult.
     */
    public static RedisPatchScheduleListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RedisPatchScheduleListResult deserializedRedisPatchScheduleListResult = new RedisPatchScheduleListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<RedisPatchScheduleInner> value
                        = reader.readArray(reader1 -> RedisPatchScheduleInner.fromJson(reader1));
                    deserializedRedisPatchScheduleListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedRedisPatchScheduleListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRedisPatchScheduleListResult;
        });
    }
}
