// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Parameters for Redis export operation.
 */
@Fluent
public final class ExportRdbParameters implements JsonSerializable<ExportRdbParameters> {
    /*
     * File format.
     */
    private String format;

    /*
     * Prefix to use for exported files.
     */
    private String prefix;

    /*
     * Container name to export to.
     */
    private String container;

    /*
     * Preferred auth method to communicate to storage account used for data archive, specify SAS or ManagedIdentity,
     * default value is SAS
     */
    private String preferredDataArchiveAuthMethod;

    /*
     * Subscription id of the storage container for data to be exported using ManagedIdentity.
     */
    private String storageSubscriptionId;

    /**
     * Creates an instance of ExportRdbParameters class.
     */
    public ExportRdbParameters() {
    }

    /**
     * Get the format property: File format.
     * 
     * @return the format value.
     */
    public String format() {
        return this.format;
    }

    /**
     * Set the format property: File format.
     * 
     * @param format the format value to set.
     * @return the ExportRdbParameters object itself.
     */
    public ExportRdbParameters withFormat(String format) {
        this.format = format;
        return this;
    }

    /**
     * Get the prefix property: Prefix to use for exported files.
     * 
     * @return the prefix value.
     */
    public String prefix() {
        return this.prefix;
    }

    /**
     * Set the prefix property: Prefix to use for exported files.
     * 
     * @param prefix the prefix value to set.
     * @return the ExportRdbParameters object itself.
     */
    public ExportRdbParameters withPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    /**
     * Get the container property: Container name to export to.
     * 
     * @return the container value.
     */
    public String container() {
        return this.container;
    }

    /**
     * Set the container property: Container name to export to.
     * 
     * @param container the container value to set.
     * @return the ExportRdbParameters object itself.
     */
    public ExportRdbParameters withContainer(String container) {
        this.container = container;
        return this;
    }

    /**
     * Get the preferredDataArchiveAuthMethod property: Preferred auth method to communicate to storage account used for
     * data archive, specify SAS or ManagedIdentity, default value is SAS.
     * 
     * @return the preferredDataArchiveAuthMethod value.
     */
    public String preferredDataArchiveAuthMethod() {
        return this.preferredDataArchiveAuthMethod;
    }

    /**
     * Set the preferredDataArchiveAuthMethod property: Preferred auth method to communicate to storage account used for
     * data archive, specify SAS or ManagedIdentity, default value is SAS.
     * 
     * @param preferredDataArchiveAuthMethod the preferredDataArchiveAuthMethod value to set.
     * @return the ExportRdbParameters object itself.
     */
    public ExportRdbParameters withPreferredDataArchiveAuthMethod(String preferredDataArchiveAuthMethod) {
        this.preferredDataArchiveAuthMethod = preferredDataArchiveAuthMethod;
        return this;
    }

    /**
     * Get the storageSubscriptionId property: Subscription id of the storage container for data to be exported using
     * ManagedIdentity.
     * 
     * @return the storageSubscriptionId value.
     */
    public String storageSubscriptionId() {
        return this.storageSubscriptionId;
    }

    /**
     * Set the storageSubscriptionId property: Subscription id of the storage container for data to be exported using
     * ManagedIdentity.
     * 
     * @param storageSubscriptionId the storageSubscriptionId value to set.
     * @return the ExportRdbParameters object itself.
     */
    public ExportRdbParameters withStorageSubscriptionId(String storageSubscriptionId) {
        this.storageSubscriptionId = storageSubscriptionId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (prefix() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property prefix in model ExportRdbParameters"));
        }
        if (container() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property container in model ExportRdbParameters"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ExportRdbParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("prefix", this.prefix);
        jsonWriter.writeStringField("container", this.container);
        jsonWriter.writeStringField("format", this.format);
        jsonWriter.writeStringField("preferred-data-archive-auth-method", this.preferredDataArchiveAuthMethod);
        jsonWriter.writeStringField("storage-subscription-id", this.storageSubscriptionId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExportRdbParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExportRdbParameters if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ExportRdbParameters.
     */
    public static ExportRdbParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExportRdbParameters deserializedExportRdbParameters = new ExportRdbParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("prefix".equals(fieldName)) {
                    deserializedExportRdbParameters.prefix = reader.getString();
                } else if ("container".equals(fieldName)) {
                    deserializedExportRdbParameters.container = reader.getString();
                } else if ("format".equals(fieldName)) {
                    deserializedExportRdbParameters.format = reader.getString();
                } else if ("preferred-data-archive-auth-method".equals(fieldName)) {
                    deserializedExportRdbParameters.preferredDataArchiveAuthMethod = reader.getString();
                } else if ("storage-subscription-id".equals(fieldName)) {
                    deserializedExportRdbParameters.storageSubscriptionId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExportRdbParameters;
        });
    }
}
