// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redis.models.AccessPolicyAssignmentProvisioningState;
import java.io.IOException;

/**
 * Properties for an access policy assignment.
 */
@Fluent
public final class RedisCacheAccessPolicyAssignmentProperties
    implements JsonSerializable<RedisCacheAccessPolicyAssignmentProperties> {
    /*
     * Provisioning state of an access policy assignment set
     */
    private AccessPolicyAssignmentProvisioningState provisioningState;

    /*
     * Object Id to assign access policy to
     */
    private String objectId;

    /*
     * User friendly name for object id. Also represents username for token based authentication
     */
    private String objectIdAlias;

    /*
     * The name of the access policy that is being assigned
     */
    private String accessPolicyName;

    /**
     * Creates an instance of RedisCacheAccessPolicyAssignmentProperties class.
     */
    public RedisCacheAccessPolicyAssignmentProperties() {
    }

    /**
     * Get the provisioningState property: Provisioning state of an access policy assignment set.
     * 
     * @return the provisioningState value.
     */
    public AccessPolicyAssignmentProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the objectId property: Object Id to assign access policy to.
     * 
     * @return the objectId value.
     */
    public String objectId() {
        return this.objectId;
    }

    /**
     * Set the objectId property: Object Id to assign access policy to.
     * 
     * @param objectId the objectId value to set.
     * @return the RedisCacheAccessPolicyAssignmentProperties object itself.
     */
    public RedisCacheAccessPolicyAssignmentProperties withObjectId(String objectId) {
        this.objectId = objectId;
        return this;
    }

    /**
     * Get the objectIdAlias property: User friendly name for object id. Also represents username for token based
     * authentication.
     * 
     * @return the objectIdAlias value.
     */
    public String objectIdAlias() {
        return this.objectIdAlias;
    }

    /**
     * Set the objectIdAlias property: User friendly name for object id. Also represents username for token based
     * authentication.
     * 
     * @param objectIdAlias the objectIdAlias value to set.
     * @return the RedisCacheAccessPolicyAssignmentProperties object itself.
     */
    public RedisCacheAccessPolicyAssignmentProperties withObjectIdAlias(String objectIdAlias) {
        this.objectIdAlias = objectIdAlias;
        return this;
    }

    /**
     * Get the accessPolicyName property: The name of the access policy that is being assigned.
     * 
     * @return the accessPolicyName value.
     */
    public String accessPolicyName() {
        return this.accessPolicyName;
    }

    /**
     * Set the accessPolicyName property: The name of the access policy that is being assigned.
     * 
     * @param accessPolicyName the accessPolicyName value to set.
     * @return the RedisCacheAccessPolicyAssignmentProperties object itself.
     */
    public RedisCacheAccessPolicyAssignmentProperties withAccessPolicyName(String accessPolicyName) {
        this.accessPolicyName = accessPolicyName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (objectId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property objectId in model RedisCacheAccessPolicyAssignmentProperties"));
        }
        if (objectIdAlias() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property objectIdAlias in model RedisCacheAccessPolicyAssignmentProperties"));
        }
        if (accessPolicyName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property accessPolicyName in model RedisCacheAccessPolicyAssignmentProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RedisCacheAccessPolicyAssignmentProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("objectId", this.objectId);
        jsonWriter.writeStringField("objectIdAlias", this.objectIdAlias);
        jsonWriter.writeStringField("accessPolicyName", this.accessPolicyName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RedisCacheAccessPolicyAssignmentProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RedisCacheAccessPolicyAssignmentProperties if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RedisCacheAccessPolicyAssignmentProperties.
     */
    public static RedisCacheAccessPolicyAssignmentProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RedisCacheAccessPolicyAssignmentProperties deserializedRedisCacheAccessPolicyAssignmentProperties
                = new RedisCacheAccessPolicyAssignmentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("objectId".equals(fieldName)) {
                    deserializedRedisCacheAccessPolicyAssignmentProperties.objectId = reader.getString();
                } else if ("objectIdAlias".equals(fieldName)) {
                    deserializedRedisCacheAccessPolicyAssignmentProperties.objectIdAlias = reader.getString();
                } else if ("accessPolicyName".equals(fieldName)) {
                    deserializedRedisCacheAccessPolicyAssignmentProperties.accessPolicyName = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedRedisCacheAccessPolicyAssignmentProperties.provisioningState
                        = AccessPolicyAssignmentProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRedisCacheAccessPolicyAssignmentProperties;
        });
    }
}
