// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redis.models.OperationStatusResult;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

/**
 * Asynchronous operation status.
 */
@Fluent
public final class OperationStatusInner extends OperationStatusResult {
    /*
     * Additional properties from RP, only when operation is successful
     */
    private Map<String, Object> properties;

    /**
     * Creates an instance of OperationStatusInner class.
     */
    public OperationStatusInner() {
    }

    /**
     * Get the properties property: Additional properties from RP, only when operation is successful.
     * 
     * @return the properties value.
     */
    public Map<String, Object> properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Additional properties from RP, only when operation is successful.
     * 
     * @param properties the properties value to set.
     * @return the OperationStatusInner object itself.
     */
    public OperationStatusInner withProperties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public OperationStatusInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public OperationStatusInner withName(String name) {
        super.withName(name);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public OperationStatusInner withStatus(String status) {
        super.withStatus(status);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public OperationStatusInner withPercentComplete(Float percentComplete) {
        super.withPercentComplete(percentComplete);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public OperationStatusInner withStartTime(OffsetDateTime startTime) {
        super.withStartTime(startTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public OperationStatusInner withEndTime(OffsetDateTime endTime) {
        super.withEndTime(endTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public OperationStatusInner withOperations(List<OperationStatusResult> operations) {
        super.withOperations(operations);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public OperationStatusInner withError(ManagementError error) {
        super.withError(error);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (status() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property status in model OperationStatusInner"));
        }
        if (operations() != null) {
            operations().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(OperationStatusInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", status());
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("name", name());
        jsonWriter.writeNumberField("percentComplete", percentComplete());
        jsonWriter.writeStringField("startTime",
            startTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(startTime()));
        jsonWriter.writeStringField("endTime",
            endTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(endTime()));
        jsonWriter.writeArrayField("operations", operations(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("error", error());
        jsonWriter.writeMapField("properties", this.properties, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OperationStatusInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OperationStatusInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the OperationStatusInner.
     */
    public static OperationStatusInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OperationStatusInner deserializedOperationStatusInner = new OperationStatusInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("status".equals(fieldName)) {
                    deserializedOperationStatusInner.withStatus(reader.getString());
                } else if ("id".equals(fieldName)) {
                    deserializedOperationStatusInner.withId(reader.getString());
                } else if ("name".equals(fieldName)) {
                    deserializedOperationStatusInner.withName(reader.getString());
                } else if ("percentComplete".equals(fieldName)) {
                    deserializedOperationStatusInner.withPercentComplete(reader.getNullable(JsonReader::getFloat));
                } else if ("startTime".equals(fieldName)) {
                    deserializedOperationStatusInner.withStartTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("endTime".equals(fieldName)) {
                    deserializedOperationStatusInner.withEndTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("operations".equals(fieldName)) {
                    List<OperationStatusResult> operations
                        = reader.readArray(reader1 -> OperationStatusResult.fromJson(reader1));
                    deserializedOperationStatusInner.withOperations(operations);
                } else if ("error".equals(fieldName)) {
                    deserializedOperationStatusInner.withError(ManagementError.fromJson(reader));
                } else if ("properties".equals(fieldName)) {
                    Map<String, Object> properties = reader.readMap(reader1 -> reader1.readUntyped());
                    deserializedOperationStatusInner.properties = properties;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOperationStatusInner;
        });
    }
}
