// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.redis.models.ReplicationRole;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Response to put/get linked server (with properties) for Redis cache. */
@Fluent
public final class RedisLinkedServerWithPropertiesInner extends ProxyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(RedisLinkedServerWithPropertiesInner.class);

    /*
     * Properties of the linked server.
     */
    @JsonProperty(value = "properties")
    private RedisLinkedServerProperties innerProperties;

    /**
     * Get the innerProperties property: Properties of the linked server.
     *
     * @return the innerProperties value.
     */
    private RedisLinkedServerProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the provisioningState property: Terminal state of the link between primary and secondary redis cache.
     *
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the linkedRedisCacheId property: Fully qualified resourceId of the linked redis cache.
     *
     * @return the linkedRedisCacheId value.
     */
    public String linkedRedisCacheId() {
        return this.innerProperties() == null ? null : this.innerProperties().linkedRedisCacheId();
    }

    /**
     * Set the linkedRedisCacheId property: Fully qualified resourceId of the linked redis cache.
     *
     * @param linkedRedisCacheId the linkedRedisCacheId value to set.
     * @return the RedisLinkedServerWithPropertiesInner object itself.
     */
    public RedisLinkedServerWithPropertiesInner withLinkedRedisCacheId(String linkedRedisCacheId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisLinkedServerProperties();
        }
        this.innerProperties().withLinkedRedisCacheId(linkedRedisCacheId);
        return this;
    }

    /**
     * Get the linkedRedisCacheLocation property: Location of the linked redis cache.
     *
     * @return the linkedRedisCacheLocation value.
     */
    public String linkedRedisCacheLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().linkedRedisCacheLocation();
    }

    /**
     * Set the linkedRedisCacheLocation property: Location of the linked redis cache.
     *
     * @param linkedRedisCacheLocation the linkedRedisCacheLocation value to set.
     * @return the RedisLinkedServerWithPropertiesInner object itself.
     */
    public RedisLinkedServerWithPropertiesInner withLinkedRedisCacheLocation(String linkedRedisCacheLocation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisLinkedServerProperties();
        }
        this.innerProperties().withLinkedRedisCacheLocation(linkedRedisCacheLocation);
        return this;
    }

    /**
     * Get the serverRole property: Role of the linked server.
     *
     * @return the serverRole value.
     */
    public ReplicationRole serverRole() {
        return this.innerProperties() == null ? null : this.innerProperties().serverRole();
    }

    /**
     * Set the serverRole property: Role of the linked server.
     *
     * @param serverRole the serverRole value to set.
     * @return the RedisLinkedServerWithPropertiesInner object itself.
     */
    public RedisLinkedServerWithPropertiesInner withServerRole(ReplicationRole serverRole) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisLinkedServerProperties();
        }
        this.innerProperties().withServerRole(serverRole);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
