/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.Direction;
import com.azure.resourcemanager.network.models.IpFlowProtocol;
import java.io.IOException;

public final class VerificationIpFlowParameters
implements JsonSerializable<VerificationIpFlowParameters> {
    private String targetResourceId;
    private Direction direction;
    private IpFlowProtocol protocol;
    private String localPort;
    private String remotePort;
    private String localIpAddress;
    private String remoteIpAddress;
    private String targetNicResourceId;
    private static final ClientLogger LOGGER = new ClientLogger(VerificationIpFlowParameters.class);

    public String targetResourceId() {
        return this.targetResourceId;
    }

    public VerificationIpFlowParameters withTargetResourceId(String targetResourceId) {
        this.targetResourceId = targetResourceId;
        return this;
    }

    public Direction direction() {
        return this.direction;
    }

    public VerificationIpFlowParameters withDirection(Direction direction) {
        this.direction = direction;
        return this;
    }

    public IpFlowProtocol protocol() {
        return this.protocol;
    }

    public VerificationIpFlowParameters withProtocol(IpFlowProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public String localPort() {
        return this.localPort;
    }

    public VerificationIpFlowParameters withLocalPort(String localPort) {
        this.localPort = localPort;
        return this;
    }

    public String remotePort() {
        return this.remotePort;
    }

    public VerificationIpFlowParameters withRemotePort(String remotePort) {
        this.remotePort = remotePort;
        return this;
    }

    public String localIpAddress() {
        return this.localIpAddress;
    }

    public VerificationIpFlowParameters withLocalIpAddress(String localIpAddress) {
        this.localIpAddress = localIpAddress;
        return this;
    }

    public String remoteIpAddress() {
        return this.remoteIpAddress;
    }

    public VerificationIpFlowParameters withRemoteIpAddress(String remoteIpAddress) {
        this.remoteIpAddress = remoteIpAddress;
        return this;
    }

    public String targetNicResourceId() {
        return this.targetNicResourceId;
    }

    public VerificationIpFlowParameters withTargetNicResourceId(String targetNicResourceId) {
        this.targetNicResourceId = targetNicResourceId;
        return this;
    }

    public void validate() {
        if (this.targetResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetResourceId in model VerificationIpFlowParameters"));
        }
        if (this.direction() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property direction in model VerificationIpFlowParameters"));
        }
        if (this.protocol() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property protocol in model VerificationIpFlowParameters"));
        }
        if (this.localPort() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property localPort in model VerificationIpFlowParameters"));
        }
        if (this.remotePort() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property remotePort in model VerificationIpFlowParameters"));
        }
        if (this.localIpAddress() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property localIpAddress in model VerificationIpFlowParameters"));
        }
        if (this.remoteIpAddress() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property remoteIpAddress in model VerificationIpFlowParameters"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetResourceId", this.targetResourceId);
        jsonWriter.writeStringField("direction", this.direction == null ? null : this.direction.toString());
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeStringField("localPort", this.localPort);
        jsonWriter.writeStringField("remotePort", this.remotePort);
        jsonWriter.writeStringField("localIPAddress", this.localIpAddress);
        jsonWriter.writeStringField("remoteIPAddress", this.remoteIpAddress);
        jsonWriter.writeStringField("targetNicResourceId", this.targetNicResourceId);
        return jsonWriter.writeEndObject();
    }

    public static VerificationIpFlowParameters fromJson(JsonReader jsonReader) throws IOException {
        return (VerificationIpFlowParameters)jsonReader.readObject(reader -> {
            VerificationIpFlowParameters deserializedVerificationIpFlowParameters = new VerificationIpFlowParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetResourceId".equals(fieldName)) {
                    deserializedVerificationIpFlowParameters.targetResourceId = reader.getString();
                    continue;
                }
                if ("direction".equals(fieldName)) {
                    deserializedVerificationIpFlowParameters.direction = Direction.fromString(reader.getString());
                    continue;
                }
                if ("protocol".equals(fieldName)) {
                    deserializedVerificationIpFlowParameters.protocol = IpFlowProtocol.fromString(reader.getString());
                    continue;
                }
                if ("localPort".equals(fieldName)) {
                    deserializedVerificationIpFlowParameters.localPort = reader.getString();
                    continue;
                }
                if ("remotePort".equals(fieldName)) {
                    deserializedVerificationIpFlowParameters.remotePort = reader.getString();
                    continue;
                }
                if ("localIPAddress".equals(fieldName)) {
                    deserializedVerificationIpFlowParameters.localIpAddress = reader.getString();
                    continue;
                }
                if ("remoteIPAddress".equals(fieldName)) {
                    deserializedVerificationIpFlowParameters.remoteIpAddress = reader.getString();
                    continue;
                }
                if ("targetNicResourceId".equals(fieldName)) {
                    deserializedVerificationIpFlowParameters.targetNicResourceId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVerificationIpFlowParameters;
        });
    }
}

