/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayPathRuleInner;
import com.azure.resourcemanager.network.implementation.ApplicationGatewayImpl;
import com.azure.resourcemanager.network.implementation.ApplicationGatewayUrlPathMapImpl;
import com.azure.resourcemanager.network.models.ApplicationGateway;
import com.azure.resourcemanager.network.models.ApplicationGatewayBackend;
import com.azure.resourcemanager.network.models.ApplicationGatewayBackendHttpConfiguration;
import com.azure.resourcemanager.network.models.ApplicationGatewayPathRule;
import com.azure.resourcemanager.network.models.ApplicationGatewayRedirectConfiguration;
import com.azure.resourcemanager.network.models.ApplicationGatewayUrlPathMap;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class ApplicationGatewayPathRuleImpl
extends ChildResourceImpl<ApplicationGatewayPathRuleInner, ApplicationGatewayUrlPathMapImpl, ApplicationGatewayUrlPathMap>
implements ApplicationGatewayPathRule,
ApplicationGatewayPathRule.Definition<ApplicationGatewayUrlPathMap.DefinitionStages.WithAttach<ApplicationGateway.DefinitionStages.WithRequestRoutingRuleOrCreate>>,
ApplicationGatewayPathRule.UpdateDefinition<ApplicationGatewayUrlPathMap.UpdateDefinitionStages.WithAttach<ApplicationGateway.Update>>,
ApplicationGatewayPathRule.Update {
    ApplicationGatewayPathRuleImpl(ApplicationGatewayPathRuleInner inner, ApplicationGatewayUrlPathMapImpl parent) {
        super((Object)inner, (Object)parent);
    }

    public String name() {
        return ((ApplicationGatewayPathRuleInner)((Object)this.innerModel())).name();
    }

    public ApplicationGatewayUrlPathMapImpl attach() {
        return ((ApplicationGatewayUrlPathMapImpl)this.parent()).withPathRule(this);
    }

    public ApplicationGatewayPathRuleImpl toBackendHttpConfiguration(String name) {
        SubResource httpConfigRef = new SubResource().withId(((ApplicationGatewayImpl)((ApplicationGatewayUrlPathMapImpl)this.parent()).parent()).futureResourceId() + "/backendHttpSettingsCollection/" + name);
        ((ApplicationGatewayPathRuleInner)((Object)this.innerModel())).withBackendHttpSettings(httpConfigRef);
        return this;
    }

    public ApplicationGatewayPathRuleImpl toBackend(String name) {
        ((ApplicationGatewayPathRuleInner)((Object)this.innerModel())).withBackendAddressPool(((ApplicationGatewayImpl)((ApplicationGatewayUrlPathMapImpl)this.parent()).parent()).ensureBackendRef(name));
        return this;
    }

    public ApplicationGatewayPathRuleImpl withRedirectConfiguration(String name) {
        if (name == null) {
            ((ApplicationGatewayPathRuleInner)((Object)this.innerModel())).withRedirectConfiguration(null);
        } else {
            SubResource ref = new SubResource().withId(((ApplicationGatewayImpl)((ApplicationGatewayUrlPathMapImpl)this.parent()).parent()).futureResourceId() + "/redirectConfigurations/" + name);
            ((ApplicationGatewayPathRuleInner)((Object)this.innerModel())).withRedirectConfiguration(ref);
        }
        return this;
    }

    @Override
    public ApplicationGatewayBackend backend() {
        SubResource backendRef = ((ApplicationGatewayPathRuleInner)((Object)this.innerModel())).backendAddressPool();
        if (backendRef != null) {
            String backendName = ResourceUtils.nameFromResourceId((String)backendRef.id());
            return ((ApplicationGatewayImpl)((ApplicationGatewayUrlPathMapImpl)this.parent()).parent()).backends().get(backendName);
        }
        return null;
    }

    @Override
    public ApplicationGatewayBackendHttpConfiguration backendHttpConfiguration() {
        SubResource configRef = ((ApplicationGatewayPathRuleInner)((Object)this.innerModel())).backendHttpSettings();
        if (configRef != null) {
            String configName = ResourceUtils.nameFromResourceId((String)configRef.id());
            return ((ApplicationGatewayImpl)((ApplicationGatewayUrlPathMapImpl)this.parent()).parent()).backendHttpConfigurations().get(configName);
        }
        return null;
    }

    @Override
    public ApplicationGatewayRedirectConfiguration redirectConfiguration() {
        SubResource ref = ((ApplicationGatewayPathRuleInner)((Object)this.innerModel())).redirectConfiguration();
        if (ref == null) {
            return null;
        }
        return ((ApplicationGatewayImpl)((ApplicationGatewayUrlPathMapImpl)this.parent()).parent()).redirectConfigurations().get(ResourceUtils.nameFromResourceId((String)ref.id()));
    }

    @Override
    public List<String> paths() {
        return Collections.unmodifiableList(((ApplicationGatewayPathRuleInner)((Object)this.innerModel())).paths());
    }

    public ApplicationGatewayPathRuleImpl withPath(String path) {
        if (((ApplicationGatewayPathRuleInner)((Object)this.innerModel())).paths() == null) {
            ((ApplicationGatewayPathRuleInner)((Object)this.innerModel())).withPaths(new ArrayList<String>());
        }
        ((ApplicationGatewayPathRuleInner)((Object)this.innerModel())).paths().add(path);
        return this;
    }

    public ApplicationGatewayPathRuleImpl withPaths(String ... paths) {
        ((ApplicationGatewayPathRuleInner)((Object)this.innerModel())).withPaths(Arrays.asList(paths));
        return this;
    }
}

