/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VpnLinkBgpSettings;
import com.azure.resourcemanager.network.models.VpnLinkProviderProperties;
import java.io.IOException;

public final class VpnSiteLinkProperties
implements JsonSerializable<VpnSiteLinkProperties> {
    private VpnLinkProviderProperties linkProperties;
    private String ipAddress;
    private String fqdn;
    private VpnLinkBgpSettings bgpProperties;
    private ProvisioningState provisioningState;

    public VpnLinkProviderProperties linkProperties() {
        return this.linkProperties;
    }

    public VpnSiteLinkProperties withLinkProperties(VpnLinkProviderProperties linkProperties) {
        this.linkProperties = linkProperties;
        return this;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public VpnSiteLinkProperties withIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    public String fqdn() {
        return this.fqdn;
    }

    public VpnSiteLinkProperties withFqdn(String fqdn) {
        this.fqdn = fqdn;
        return this;
    }

    public VpnLinkBgpSettings bgpProperties() {
        return this.bgpProperties;
    }

    public VpnSiteLinkProperties withBgpProperties(VpnLinkBgpSettings bgpProperties) {
        this.bgpProperties = bgpProperties;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.linkProperties() != null) {
            this.linkProperties().validate();
        }
        if (this.bgpProperties() != null) {
            this.bgpProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkProperties", (JsonSerializable)this.linkProperties);
        jsonWriter.writeStringField("ipAddress", this.ipAddress);
        jsonWriter.writeStringField("fqdn", this.fqdn);
        jsonWriter.writeJsonField("bgpProperties", (JsonSerializable)this.bgpProperties);
        return jsonWriter.writeEndObject();
    }

    public static VpnSiteLinkProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VpnSiteLinkProperties)jsonReader.readObject(reader -> {
            VpnSiteLinkProperties deserializedVpnSiteLinkProperties = new VpnSiteLinkProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkProperties".equals(fieldName)) {
                    deserializedVpnSiteLinkProperties.linkProperties = VpnLinkProviderProperties.fromJson(reader);
                    continue;
                }
                if ("ipAddress".equals(fieldName)) {
                    deserializedVpnSiteLinkProperties.ipAddress = reader.getString();
                    continue;
                }
                if ("fqdn".equals(fieldName)) {
                    deserializedVpnSiteLinkProperties.fqdn = reader.getString();
                    continue;
                }
                if ("bgpProperties".equals(fieldName)) {
                    deserializedVpnSiteLinkProperties.bgpProperties = VpnLinkBgpSettings.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVpnSiteLinkProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVpnSiteLinkProperties;
        });
    }
}

