/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.PrivateEndpointInner;
import com.azure.resourcemanager.network.models.PrivateLinkServiceConnectionState;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

public final class PrivateEndpointConnectionPropertiesInner
implements JsonSerializable<PrivateEndpointConnectionPropertiesInner> {
    private PrivateEndpointInner privateEndpoint;
    private PrivateLinkServiceConnectionState privateLinkServiceConnectionState;
    private ProvisioningState provisioningState;
    private String linkIdentifier;
    private String privateEndpointLocation;

    public PrivateEndpointInner privateEndpoint() {
        return this.privateEndpoint;
    }

    public PrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
        return this.privateLinkServiceConnectionState;
    }

    public PrivateEndpointConnectionPropertiesInner withPrivateLinkServiceConnectionState(PrivateLinkServiceConnectionState privateLinkServiceConnectionState) {
        this.privateLinkServiceConnectionState = privateLinkServiceConnectionState;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String linkIdentifier() {
        return this.linkIdentifier;
    }

    public String privateEndpointLocation() {
        return this.privateEndpointLocation;
    }

    public void validate() {
        if (this.privateEndpoint() != null) {
            this.privateEndpoint().validate();
        }
        if (this.privateLinkServiceConnectionState() != null) {
            this.privateLinkServiceConnectionState().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("privateLinkServiceConnectionState", (JsonSerializable)this.privateLinkServiceConnectionState);
        return jsonWriter.writeEndObject();
    }

    public static PrivateEndpointConnectionPropertiesInner fromJson(JsonReader jsonReader) throws IOException {
        return (PrivateEndpointConnectionPropertiesInner)jsonReader.readObject(reader -> {
            PrivateEndpointConnectionPropertiesInner deserializedPrivateEndpointConnectionPropertiesInner = new PrivateEndpointConnectionPropertiesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("privateEndpoint".equals(fieldName)) {
                    deserializedPrivateEndpointConnectionPropertiesInner.privateEndpoint = PrivateEndpointInner.fromJson(reader);
                    continue;
                }
                if ("privateLinkServiceConnectionState".equals(fieldName)) {
                    deserializedPrivateEndpointConnectionPropertiesInner.privateLinkServiceConnectionState = PrivateLinkServiceConnectionState.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedPrivateEndpointConnectionPropertiesInner.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("linkIdentifier".equals(fieldName)) {
                    deserializedPrivateEndpointConnectionPropertiesInner.linkIdentifier = reader.getString();
                    continue;
                }
                if ("privateEndpointLocation".equals(fieldName)) {
                    deserializedPrivateEndpointConnectionPropertiesInner.privateEndpointLocation = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrivateEndpointConnectionPropertiesInner;
        });
    }
}

