/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.P2SConnectionConfiguration;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VpnClientConnectionHealth;
import java.io.IOException;
import java.util.List;

public final class P2SVpnGatewayProperties
implements JsonSerializable<P2SVpnGatewayProperties> {
    private SubResource virtualHub;
    private List<P2SConnectionConfiguration> p2SConnectionConfigurations;
    private ProvisioningState provisioningState;
    private Integer vpnGatewayScaleUnit;
    private SubResource vpnServerConfiguration;
    private VpnClientConnectionHealth vpnClientConnectionHealth;
    private List<String> customDnsServers;
    private Boolean isRoutingPreferenceInternet;

    public SubResource virtualHub() {
        return this.virtualHub;
    }

    public P2SVpnGatewayProperties withVirtualHub(SubResource virtualHub) {
        this.virtualHub = virtualHub;
        return this;
    }

    public List<P2SConnectionConfiguration> p2SConnectionConfigurations() {
        return this.p2SConnectionConfigurations;
    }

    public P2SVpnGatewayProperties withP2SConnectionConfigurations(List<P2SConnectionConfiguration> p2SConnectionConfigurations) {
        this.p2SConnectionConfigurations = p2SConnectionConfigurations;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Integer vpnGatewayScaleUnit() {
        return this.vpnGatewayScaleUnit;
    }

    public P2SVpnGatewayProperties withVpnGatewayScaleUnit(Integer vpnGatewayScaleUnit) {
        this.vpnGatewayScaleUnit = vpnGatewayScaleUnit;
        return this;
    }

    public SubResource vpnServerConfiguration() {
        return this.vpnServerConfiguration;
    }

    public P2SVpnGatewayProperties withVpnServerConfiguration(SubResource vpnServerConfiguration) {
        this.vpnServerConfiguration = vpnServerConfiguration;
        return this;
    }

    public VpnClientConnectionHealth vpnClientConnectionHealth() {
        return this.vpnClientConnectionHealth;
    }

    public List<String> customDnsServers() {
        return this.customDnsServers;
    }

    public P2SVpnGatewayProperties withCustomDnsServers(List<String> customDnsServers) {
        this.customDnsServers = customDnsServers;
        return this;
    }

    public Boolean isRoutingPreferenceInternet() {
        return this.isRoutingPreferenceInternet;
    }

    public P2SVpnGatewayProperties withIsRoutingPreferenceInternet(Boolean isRoutingPreferenceInternet) {
        this.isRoutingPreferenceInternet = isRoutingPreferenceInternet;
        return this;
    }

    public void validate() {
        if (this.p2SConnectionConfigurations() != null) {
            this.p2SConnectionConfigurations().forEach(e -> e.validate());
        }
        if (this.vpnClientConnectionHealth() != null) {
            this.vpnClientConnectionHealth().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("virtualHub", (JsonSerializable)this.virtualHub);
        jsonWriter.writeArrayField("p2SConnectionConfigurations", this.p2SConnectionConfigurations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("vpnGatewayScaleUnit", (Number)this.vpnGatewayScaleUnit);
        jsonWriter.writeJsonField("vpnServerConfiguration", (JsonSerializable)this.vpnServerConfiguration);
        jsonWriter.writeArrayField("customDnsServers", this.customDnsServers, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("isRoutingPreferenceInternet", this.isRoutingPreferenceInternet);
        return jsonWriter.writeEndObject();
    }

    public static P2SVpnGatewayProperties fromJson(JsonReader jsonReader) throws IOException {
        return (P2SVpnGatewayProperties)jsonReader.readObject(reader -> {
            P2SVpnGatewayProperties deserializedP2SVpnGatewayProperties = new P2SVpnGatewayProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("virtualHub".equals(fieldName)) {
                    deserializedP2SVpnGatewayProperties.virtualHub = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("p2SConnectionConfigurations".equals(fieldName)) {
                    List p2SConnectionConfigurations;
                    deserializedP2SVpnGatewayProperties.p2SConnectionConfigurations = p2SConnectionConfigurations = reader.readArray(reader1 -> P2SConnectionConfiguration.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedP2SVpnGatewayProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("vpnGatewayScaleUnit".equals(fieldName)) {
                    deserializedP2SVpnGatewayProperties.vpnGatewayScaleUnit = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("vpnServerConfiguration".equals(fieldName)) {
                    deserializedP2SVpnGatewayProperties.vpnServerConfiguration = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("vpnClientConnectionHealth".equals(fieldName)) {
                    deserializedP2SVpnGatewayProperties.vpnClientConnectionHealth = VpnClientConnectionHealth.fromJson(reader);
                    continue;
                }
                if ("customDnsServers".equals(fieldName)) {
                    List customDnsServers;
                    deserializedP2SVpnGatewayProperties.customDnsServers = customDnsServers = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("isRoutingPreferenceInternet".equals(fieldName)) {
                    deserializedP2SVpnGatewayProperties.isRoutingPreferenceInternet = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedP2SVpnGatewayProperties;
        });
    }
}

