/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ErrorDetail;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class OperationStatusResultInner
implements JsonSerializable<OperationStatusResultInner> {
    private String id;
    private String resourceId;
    private String name;
    private String status;
    private Float percentComplete;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private List<OperationStatusResultInner> operations;
    private ErrorDetail error;
    private static final ClientLogger LOGGER = new ClientLogger(OperationStatusResultInner.class);

    public String id() {
        return this.id;
    }

    public OperationStatusResultInner withId(String id) {
        this.id = id;
        return this;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String name() {
        return this.name;
    }

    public OperationStatusResultInner withName(String name) {
        this.name = name;
        return this;
    }

    public String status() {
        return this.status;
    }

    public OperationStatusResultInner withStatus(String status) {
        this.status = status;
        return this;
    }

    public Float percentComplete() {
        return this.percentComplete;
    }

    public OperationStatusResultInner withPercentComplete(Float percentComplete) {
        this.percentComplete = percentComplete;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public OperationStatusResultInner withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public OperationStatusResultInner withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public List<OperationStatusResultInner> operations() {
        return this.operations;
    }

    public OperationStatusResultInner withOperations(List<OperationStatusResultInner> operations) {
        this.operations = operations;
        return this;
    }

    public ErrorDetail error() {
        return this.error;
    }

    public OperationStatusResultInner withError(ErrorDetail error) {
        this.error = error;
        return this;
    }

    public void validate() {
        if (this.status() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property status in model OperationStatusResultInner"));
        }
        if (this.operations() != null) {
            this.operations().forEach(e -> e.validate());
        }
        if (this.error() != null) {
            this.error().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeNumberField("percentComplete", (Number)this.percentComplete);
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeArrayField("operations", this.operations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        return jsonWriter.writeEndObject();
    }

    public static OperationStatusResultInner fromJson(JsonReader jsonReader) throws IOException {
        return (OperationStatusResultInner)jsonReader.readObject(reader -> {
            OperationStatusResultInner deserializedOperationStatusResultInner = new OperationStatusResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedOperationStatusResultInner.status = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedOperationStatusResultInner.id = reader.getString();
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    deserializedOperationStatusResultInner.resourceId = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedOperationStatusResultInner.name = reader.getString();
                    continue;
                }
                if ("percentComplete".equals(fieldName)) {
                    deserializedOperationStatusResultInner.percentComplete = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedOperationStatusResultInner.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedOperationStatusResultInner.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("operations".equals(fieldName)) {
                    List operations;
                    deserializedOperationStatusResultInner.operations = operations = reader.readArray(reader1 -> OperationStatusResultInner.fromJson(reader1));
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedOperationStatusResultInner.error = ErrorDetail.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationStatusResultInner;
        });
    }
}

