/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.FailoverConnectionDetails;
import java.io.IOException;
import java.util.List;

public final class ExpressRouteFailoverStopApiParameters
implements JsonSerializable<ExpressRouteFailoverStopApiParameters> {
    private String peeringLocation;
    private Boolean wasSimulationSuccessful;
    private List<FailoverConnectionDetails> details;

    public String peeringLocation() {
        return this.peeringLocation;
    }

    public ExpressRouteFailoverStopApiParameters withPeeringLocation(String peeringLocation) {
        this.peeringLocation = peeringLocation;
        return this;
    }

    public Boolean wasSimulationSuccessful() {
        return this.wasSimulationSuccessful;
    }

    public ExpressRouteFailoverStopApiParameters withWasSimulationSuccessful(Boolean wasSimulationSuccessful) {
        this.wasSimulationSuccessful = wasSimulationSuccessful;
        return this;
    }

    public List<FailoverConnectionDetails> details() {
        return this.details;
    }

    public ExpressRouteFailoverStopApiParameters withDetails(List<FailoverConnectionDetails> details) {
        this.details = details;
        return this;
    }

    public void validate() {
        if (this.details() != null) {
            this.details().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("peeringLocation", this.peeringLocation);
        jsonWriter.writeBooleanField("wasSimulationSuccessful", this.wasSimulationSuccessful);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ExpressRouteFailoverStopApiParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ExpressRouteFailoverStopApiParameters)jsonReader.readObject(reader -> {
            ExpressRouteFailoverStopApiParameters deserializedExpressRouteFailoverStopApiParameters = new ExpressRouteFailoverStopApiParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("peeringLocation".equals(fieldName)) {
                    deserializedExpressRouteFailoverStopApiParameters.peeringLocation = reader.getString();
                    continue;
                }
                if ("wasSimulationSuccessful".equals(fieldName)) {
                    deserializedExpressRouteFailoverStopApiParameters.wasSimulationSuccessful = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("details".equals(fieldName)) {
                    List details;
                    deserializedExpressRouteFailoverStopApiParameters.details = details = reader.readArray(reader1 -> FailoverConnectionDetails.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExpressRouteFailoverStopApiParameters;
        });
    }
}

