/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.MatchedRule;
import com.azure.resourcemanager.network.models.NetworkSecurityRulesEvaluationResult;
import java.io.IOException;
import java.util.List;

public final class EvaluatedNetworkSecurityGroup
implements JsonSerializable<EvaluatedNetworkSecurityGroup> {
    private String networkSecurityGroupId;
    private String appliedTo;
    private MatchedRule matchedRule;
    private List<NetworkSecurityRulesEvaluationResult> rulesEvaluationResult;

    public String networkSecurityGroupId() {
        return this.networkSecurityGroupId;
    }

    public EvaluatedNetworkSecurityGroup withNetworkSecurityGroupId(String networkSecurityGroupId) {
        this.networkSecurityGroupId = networkSecurityGroupId;
        return this;
    }

    public String appliedTo() {
        return this.appliedTo;
    }

    public EvaluatedNetworkSecurityGroup withAppliedTo(String appliedTo) {
        this.appliedTo = appliedTo;
        return this;
    }

    public MatchedRule matchedRule() {
        return this.matchedRule;
    }

    public EvaluatedNetworkSecurityGroup withMatchedRule(MatchedRule matchedRule) {
        this.matchedRule = matchedRule;
        return this;
    }

    public List<NetworkSecurityRulesEvaluationResult> rulesEvaluationResult() {
        return this.rulesEvaluationResult;
    }

    public void validate() {
        if (this.matchedRule() != null) {
            this.matchedRule().validate();
        }
        if (this.rulesEvaluationResult() != null) {
            this.rulesEvaluationResult().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("networkSecurityGroupId", this.networkSecurityGroupId);
        jsonWriter.writeStringField("appliedTo", this.appliedTo);
        jsonWriter.writeJsonField("matchedRule", (JsonSerializable)this.matchedRule);
        return jsonWriter.writeEndObject();
    }

    public static EvaluatedNetworkSecurityGroup fromJson(JsonReader jsonReader) throws IOException {
        return (EvaluatedNetworkSecurityGroup)jsonReader.readObject(reader -> {
            EvaluatedNetworkSecurityGroup deserializedEvaluatedNetworkSecurityGroup = new EvaluatedNetworkSecurityGroup();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("networkSecurityGroupId".equals(fieldName)) {
                    deserializedEvaluatedNetworkSecurityGroup.networkSecurityGroupId = reader.getString();
                    continue;
                }
                if ("appliedTo".equals(fieldName)) {
                    deserializedEvaluatedNetworkSecurityGroup.appliedTo = reader.getString();
                    continue;
                }
                if ("matchedRule".equals(fieldName)) {
                    deserializedEvaluatedNetworkSecurityGroup.matchedRule = MatchedRule.fromJson(reader);
                    continue;
                }
                if ("rulesEvaluationResult".equals(fieldName)) {
                    List rulesEvaluationResult;
                    deserializedEvaluatedNetworkSecurityGroup.rulesEvaluationResult = rulesEvaluationResult = reader.readArray(reader1 -> NetworkSecurityRulesEvaluationResult.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEvaluatedNetworkSecurityGroup;
        });
    }
}

