/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.HttpConfigurationMethod;
import com.azure.resourcemanager.network.models.HttpHeader;
import java.io.IOException;
import java.util.List;

public final class ConnectionMonitorHttpConfiguration
implements JsonSerializable<ConnectionMonitorHttpConfiguration> {
    private Integer port;
    private HttpConfigurationMethod method;
    private String path;
    private List<HttpHeader> requestHeaders;
    private List<String> validStatusCodeRanges;
    private Boolean preferHttps;

    public Integer port() {
        return this.port;
    }

    public ConnectionMonitorHttpConfiguration withPort(Integer port) {
        this.port = port;
        return this;
    }

    public HttpConfigurationMethod method() {
        return this.method;
    }

    public ConnectionMonitorHttpConfiguration withMethod(HttpConfigurationMethod method) {
        this.method = method;
        return this;
    }

    public String path() {
        return this.path;
    }

    public ConnectionMonitorHttpConfiguration withPath(String path) {
        this.path = path;
        return this;
    }

    public List<HttpHeader> requestHeaders() {
        return this.requestHeaders;
    }

    public ConnectionMonitorHttpConfiguration withRequestHeaders(List<HttpHeader> requestHeaders) {
        this.requestHeaders = requestHeaders;
        return this;
    }

    public List<String> validStatusCodeRanges() {
        return this.validStatusCodeRanges;
    }

    public ConnectionMonitorHttpConfiguration withValidStatusCodeRanges(List<String> validStatusCodeRanges) {
        this.validStatusCodeRanges = validStatusCodeRanges;
        return this;
    }

    public Boolean preferHttps() {
        return this.preferHttps;
    }

    public ConnectionMonitorHttpConfiguration withPreferHttps(Boolean preferHttps) {
        this.preferHttps = preferHttps;
        return this;
    }

    public void validate() {
        if (this.requestHeaders() != null) {
            this.requestHeaders().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("port", (Number)this.port);
        jsonWriter.writeStringField("method", this.method == null ? null : this.method.toString());
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeArrayField("requestHeaders", this.requestHeaders, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("validStatusCodeRanges", this.validStatusCodeRanges, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("preferHTTPS", this.preferHttps);
        return jsonWriter.writeEndObject();
    }

    public static ConnectionMonitorHttpConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectionMonitorHttpConfiguration)jsonReader.readObject(reader -> {
            ConnectionMonitorHttpConfiguration deserializedConnectionMonitorHttpConfiguration = new ConnectionMonitorHttpConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("port".equals(fieldName)) {
                    deserializedConnectionMonitorHttpConfiguration.port = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("method".equals(fieldName)) {
                    deserializedConnectionMonitorHttpConfiguration.method = HttpConfigurationMethod.fromString(reader.getString());
                    continue;
                }
                if ("path".equals(fieldName)) {
                    deserializedConnectionMonitorHttpConfiguration.path = reader.getString();
                    continue;
                }
                if ("requestHeaders".equals(fieldName)) {
                    List requestHeaders;
                    deserializedConnectionMonitorHttpConfiguration.requestHeaders = requestHeaders = reader.readArray(reader1 -> HttpHeader.fromJson(reader1));
                    continue;
                }
                if ("validStatusCodeRanges".equals(fieldName)) {
                    List validStatusCodeRanges;
                    deserializedConnectionMonitorHttpConfiguration.validStatusCodeRanges = validStatusCodeRanges = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("preferHTTPS".equals(fieldName)) {
                    deserializedConnectionMonitorHttpConfiguration.preferHttps = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectionMonitorHttpConfiguration;
        });
    }
}

