/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.PublicIpPrefixesClient;
import com.azure.resourcemanager.network.fluent.models.PublicIpPrefixInner;
import com.azure.resourcemanager.network.models.AppliableWithTags;
import com.azure.resourcemanager.network.models.IpTag;
import com.azure.resourcemanager.network.models.IpVersion;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.PublicIpPrefix;
import com.azure.resourcemanager.network.models.PublicIpPrefixSku;
import com.azure.resourcemanager.network.models.ReferencedPublicIpAddress;
import com.azure.resourcemanager.network.models.TagsObject;
import com.azure.resourcemanager.resources.fluentcore.arm.AvailabilityZoneId;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import reactor.core.publisher.Mono;

class PublicIpPrefixImpl
extends GroupableResourceImpl<PublicIpPrefix, PublicIpPrefixInner, PublicIpPrefixImpl, NetworkManager>
implements PublicIpPrefix,
PublicIpPrefix.Definition,
PublicIpPrefix.Update,
AppliableWithTags<PublicIpPrefix> {
    PublicIpPrefixImpl(String name, PublicIpPrefixInner inner, NetworkManager manager) {
        super(name, (Resource)inner, (Manager)manager);
    }

    public Mono<PublicIpPrefix> createResourceAsync() {
        PublicIpPrefixesClient client = ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getPublicIpPrefixes();
        return client.createOrUpdateAsync(this.resourceGroupName(), this.name(), (PublicIpPrefixInner)((Object)this.innerModel())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    public Mono<PublicIpPrefix> updateResourceAsync() {
        PublicIpPrefixesClient client = ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getPublicIpPrefixes();
        return client.createOrUpdateAsync(this.resourceGroupName(), this.name(), (PublicIpPrefixInner)((Object)this.innerModel())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Mono<PublicIpPrefixInner> getInnerAsync() {
        PublicIpPrefixesClient client = ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getPublicIpPrefixes();
        return client.getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public PublicIpPrefixImpl updateTags() {
        return this;
    }

    @Override
    public PublicIpPrefix applyTags() {
        return (PublicIpPrefix)this.applyTagsAsync().block();
    }

    @Override
    public Mono<PublicIpPrefix> applyTagsAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getPublicIpPrefixes().updateTagsAsync(this.resourceGroupName(), this.name(), new TagsObject().withTags(((PublicIpPrefixInner)((Object)this.innerModel())).tags())).map(inner -> {
            this.setInner(inner);
            return this;
        });
    }

    public boolean isInCreateMode() {
        return ((PublicIpPrefixInner)((Object)this.innerModel())).id() == null;
    }

    @Override
    public String ipPrefix() {
        return ((PublicIpPrefixInner)((Object)this.innerModel())).ipPrefix();
    }

    @Override
    public List<IpTag> ipTags() {
        return Collections.unmodifiableList(((PublicIpPrefixInner)((Object)this.innerModel())).ipTags() == null ? new ArrayList() : ((PublicIpPrefixInner)((Object)this.innerModel())).ipTags());
    }

    @Override
    public SubResource loadBalancerFrontendIpConfiguration() {
        return ((PublicIpPrefixInner)((Object)this.innerModel())).loadBalancerFrontendIpConfiguration();
    }

    @Override
    public Integer prefixLength() {
        return ((PublicIpPrefixInner)((Object)this.innerModel())).prefixLength();
    }

    @Override
    public ProvisioningState provisioningState() {
        return ((PublicIpPrefixInner)((Object)this.innerModel())).provisioningState();
    }

    @Override
    public List<ReferencedPublicIpAddress> publicIpAddresses() {
        return Collections.unmodifiableList(((PublicIpPrefixInner)((Object)this.innerModel())).publicIpAddresses() == null ? new ArrayList() : ((PublicIpPrefixInner)((Object)this.innerModel())).publicIpAddresses());
    }

    @Override
    public IpVersion publicIpAddressVersion() {
        return ((PublicIpPrefixInner)((Object)this.innerModel())).publicIpAddressVersion();
    }

    @Override
    public String resourceGuid() {
        return ((PublicIpPrefixInner)((Object)this.innerModel())).resourceGuid();
    }

    @Override
    public PublicIpPrefixSku sku() {
        return ((PublicIpPrefixInner)((Object)this.innerModel())).sku();
    }

    @Override
    public Set<AvailabilityZoneId> availabilityZones() {
        HashSet<AvailabilityZoneId> zones = new HashSet<AvailabilityZoneId>();
        if (((PublicIpPrefixInner)((Object)this.innerModel())).zones() != null) {
            for (String zone : ((PublicIpPrefixInner)((Object)this.innerModel())).zones()) {
                zones.add(AvailabilityZoneId.fromString((String)zone));
            }
        }
        return Collections.unmodifiableSet(zones);
    }

    @Override
    public PublicIpPrefixImpl withIpTags(List<IpTag> ipTags) {
        ((PublicIpPrefixInner)((Object)this.innerModel())).withIpTags(ipTags);
        return this;
    }

    @Override
    public PublicIpPrefixImpl withPrefixLength(Integer prefixLength) {
        ((PublicIpPrefixInner)((Object)this.innerModel())).withPrefixLength(prefixLength);
        return this;
    }

    @Override
    public PublicIpPrefixImpl withPublicIpAddressVersion(IpVersion publicIpAddressVersion) {
        ((PublicIpPrefixInner)((Object)this.innerModel())).withPublicIpAddressVersion(publicIpAddressVersion);
        return this;
    }

    @Override
    public PublicIpPrefixImpl withSku(PublicIpPrefixSku sku) {
        ((PublicIpPrefixInner)((Object)this.innerModel())).withSku(sku);
        return this;
    }

    @Override
    public PublicIpPrefixImpl withAvailabilityZone(AvailabilityZoneId zoneId) {
        if (((PublicIpPrefixInner)((Object)this.innerModel())).zones() == null) {
            ((PublicIpPrefixInner)((Object)this.innerModel())).withZones(new ArrayList<String>());
        }
        ((PublicIpPrefixInner)((Object)this.innerModel())).zones().add(zoneId.toString());
        return this;
    }
}

